<?php
/*======================================================================*\
|| #################################################################### ||
|| # v3 Arcade for vBulletin                                          # ||
|| # Support: http://www.v3arcade.com                                 # ||
|| # Copyright: http://www.cinvin.com                                 # ||
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'arcade');

// ########################## DO PREPARATION #############################
if ($_REQUEST['sessdo'])
{
	$_REQUEST['do'] = $_REQUEST['sessdo'];
}
else if ($_POST['imodform'] AND !$_POST['do'])
{
	$_POST['do'] = 'inlinemod';
	$_REQUEST['do'] = 'inlinemod'; // set $_REQUEST for the template cache
}
else if (!$_REQUEST['do'])
{
	$_REQUEST['do'] = 'home';
}

// ################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('v3arcade');

$specialtemplates = array(
	'v3a_cats',
	'v3a_challenge',
	'v3a_champs',
	'v3a_newscores',
	'v3a_tournament'
);

if ($_REQUEST['do'] == 'leaderboard')
{
	$specialtemplates[] = 'v3a_awards';
}

$globaltemplates = array(
	'v3arcade_headinclude',
	'v3arcade_navbar'
);

$actiontemplates = array(
	'home' => array(
		'v3ARCADE_MAIN',
		'v3arcade_main_champbits',
		'v3arcade_main_latestscores',
		'v3arcade_news_bit',
		'v3arcade_game_bit',
		'v3arcade_game_bit_slim',
		'v3arcade_category_bit',
		'v3arcade_category_bit_active',
		'v3arcade_challenge_minibit',
		'v3arcade_challenge_bit'
	),
	'burn' => array(
		'v3arcade_commentform',
		'v3ARCADE_SCORES',
		'v3arcade_scorebit',
		'v3arcade_scorebit_high',
		'v3arcade_recommendation'
	),
	'inlinemod' => array(
		'v3ARCADE_INLINEMOD_CONFRIM',
		'v3ARCADE_SCORES',
		'v3arcade_scorebit',
		'v3arcade_scorebit_high'
	),
	'leaderboard' => array(
		'v3ARCADE_LEADERBOARD',
		'v3arcade_leaderboardbits',
		'memberinfo_v3arcade_gamebits'
	),
	'newchallenge' => array(
		'v3ARCADE_NEWCHALLENGE'
	),
	'play' => array(
		'v3ARCADE_PLAY',
		'v3arcade_play_mochigame',
		'v3arcade_play_resolutionbits',
		'v3arcade_play_v3game'
	),
	'scores' => array(
		'v3ARCADE_SCORES',
		'v3arcade_scorebit',
		'v3arcade_scorebit_high'
	),
	'userinfosearch' => array(
		'v3arcade_miniuserinfo'
	)
);

$actiontemplates['none'] =& $actiontemplates['home'];

switch ($_REQUEST['do'])
{
	// Ajax functionality, so bypass the location update and PM popup.
	case 'ajaxsearch':
	case 'userinfosearch':
	case 'dorating':
		define('LOCATION_BYPASS', 1);
		define('NOPMPOPUP', 1);
	break;

	case 'home':
		$specialtemplates[] = 'v3a_news';
	break;

	case 'scores':
	case 'inlinemod':
		$phrasegroups[] = 'inlinemod';
		$specialtemplates[] = 'bbcodecache';
		$specialtemplates[] = 'smiliecache';
	break;

	case 'burn':
		$specialtemplates[] = 'bbcodecache';
		$specialtemplates[] = 'smiliecache';
	break;
}

// ##### Format mochiads string before vB touches any $_POST vars
if ($_REQUEST['sessdo'] == 'mochiburn' AND $_POST['signature'])
{
	// Make sure the score's valid by comparing the data to mochi's signature
	$postkeys = array_keys($_POST);
	asort($postkeys);
//array('boardID', 'datatype', 'description', 'gameID', 'name', 'score', 'scoreLabel', 'sessionID', 'sortOrder', 'title', 'userID', 'username')
	$mochisigcheck = '';
	foreach ($postkeys AS $mochikey)
	{
		if ($mochikey == 'signature' OR $mochikey == 'sessdo')
		{
			continue;
		}

		$mochisigcheck .= $mochikey . '=' . rawurlencode($_POST[$mochikey]) . '&';
	}
	$mochisigcheck = substr($mochisigcheck, 0, -1);
}

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/v3arcade_functions.php');
require_once(DIR . '/includes/functions_user.php');

($hook = vBulletinHook::fetch_hook('arcade_global_start')) ? eval($hook) : false;

// Check basic permissions.
if (!($permissions['arcadepermissions'] & $vbulletin->bf_ugp['arcadepermissions']['canviewarcade']))
{
	print_no_permission();
}

// If the Arcade is closed and you're not an admin, print the error.
if (!$vbulletin->options['arcadeopen'] AND !($vbulletin->userinfo['permissions']['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']))
{
	standard_error($vbulletin->options['arcadeclosedmessage']);
}

// Add in Arcade user options.
$vbulletin->userinfo = array_merge(
	convert_bits_to_array($vbulletin->userinfo['arcadeoptions'], $vbulletin->bf_misc_arcadeoptions),
	$vbulletin->userinfo
);

// Remove favorites category if favorites are disabled
if (!$vbulletin->options['arcade_favs'])
{
	unset($vbulletin->v3a_cats['2']);
}

// ############################################################################
// AJAX SEARCH - Instant searching.
// ############################################################################
if ($_REQUEST['do'] == 'ajaxsearch')
{
	$vbulletin->input->clean_gpc('r', 'searchstring', TYPE_STR);

	// Search for games based on string.
	$games = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "v3arcade_games
		WHERE title LIKE '%" . $db->escape_string(convert_urlencoded_unicode($vbulletin->GPC['searchstring'])) . "%'
			OR keywords LIKE '%" . $db->escape_string(convert_urlencoded_unicode($vbulletin->GPC['searchstring'])) . "%'
		ORDER BY sessioncount DESC
		LIMIT " . $vbulletin->options['quicksearchresults']
	);

	$temparray = array();
	while ($game = $db->fetch_array($games))
	{
		$temparray[] = "$game[gameid]|||$game[title]|||$game[miniimage]";
	}

	($hook = vBulletinHook::fetch_hook('arcade_ajaxsearch')) ? eval($hook) : false;

	// And send it to the browser.
	echo implode('^^^', $temparray);
	exit;
}

// ############################################################################
// DO RATING - Ajax game ratings.
// ############################################################################
if ($_REQUEST['do'] == 'dorating')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'gameid' => TYPE_UINT,
		'rating' => TYPE_UINT
	));

	// We don't want guests to be able to rate games, and make sure the rating is between 1 and 5
	if (!$vbulletin->userinfo['userid'] OR $vbulletin->GPC['rating'] > 5 OR $vbulletin->GPC['rating'] < 1)
	{
		exit;
	}

	($hook = vBulletinHook::fetch_hook('arcade_ajaxrating')) ? eval($hook) : false;

	if ($oldrating = $db->query_first("
		SELECT ratingid
		FROM " . TABLE_PREFIX . "v3arcade_ratings
		WHERE userid = " . $vbulletin->userinfo['userid'] . "
			AND gameid = " . $vbulletin->GPC['gameid']
	))
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "v3arcade_ratings SET
				rating = " . $vbulletin->GPC['rating'] . "
			WHERE ratingid = " . $oldrating['ratingid']
		);
	}
	else
	{
		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "v3arcade_ratings
				(userid, gameid, rating)
			VALUES (
				" . $vbulletin->userinfo['userid'] . ",
				" . $vbulletin->GPC['gameid'] . ",
				" . $vbulletin->GPC['rating'] . "
		)");
	}

	build_ratings($vbulletin->GPC['gameid']);

	// Provide something for the javascript to bite on.
	echo 1;
	exit;
}

// ############################################################################
// PROCESS FAVORITES - Flip the favorite for the current user's choice.
// ############################################################################
if ($_REQUEST['do'] == 'processfav')
{
	$vbulletin->input->clean_gpc('r', 'gameid', TYPE_UINT);

	if (!$vbulletin->options['arcade_favs'] OR !$vbulletin->userinfo['userid'] OR !$vbulletin->GPC['gameid'])
	{
		exit;
	}

	$favcache = unserialize($vbulletin->userinfo['favcache']);

	($hook = vBulletinHook::fetch_hook('arcade_processfav')) ? eval($hook) : false;

	if ($favcache[$vbulletin->GPC['gameid']])
	{
		$db->query_write("
			DELETE FROM " . TABLE_PREFIX . "v3arcade_favorites
			WHERE userid = " . $vbulletin->userinfo['userid'] . "
				AND gameid = " . $vbulletin->GPC['gameid']
		);

		// Favorite deleted.
		echo 2;
	}
	else
	{
		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "v3arcade_favorites
				(userid, gameid)
			VALUES (
				" . $vbulletin->userinfo['userid'] . ",
				" . $vbulletin->GPC['gameid'] . "
		)");

		// Favorite added.
		echo 1;
	}
	build_favcache();

	exit;
}

// ############################################################################
// USERINFO SEARCH - Send back a neat little userinfo table.
// ############################################################################
if ($_REQUEST['do'] == 'userinfosearch')
{
	$vbulletin->input->clean_gpc('r', 'userid', TYPE_UINT);

	if (!$vbulletin->GPC['userid'])
	{
		exit;
	}

	// Avatar processing.
	$user = fetch_userinfo($vbulletin->GPC['userid']);
	$user['avatar'] = fetch_avatar_url($user['userid']);
	$user['useravatar'] = $user['avatar'][0];
	$user['avdimensions'] = $user['avatar'][1];

	if (!$user['useravatar'])
	{
		$user['useravatar'] = $vbulletin->options['arcadeimages'] . '/noavatar.gif';
		$user['avatar'] = true;
	}

	// Some data on timing and session counts.
	$timecheck = $db->query_first("
		SELECT SUM(start) AS startcount, SUM(finish) AS finishcount, COUNT(*) AS playcount, AVG(ping) AS avgping
		FROM " . TABLE_PREFIX . "v3arcade_sessions
		WHERE start != 0
			AND finish != 0
			AND valid = 1
			AND userid = " . $vbulletin->GPC['userid']
	);

	$user['timeplayed'] = sec2hms($timecheck['finishcount'] - $timecheck['startcount']);
	$user = array_merge($user, $timecheck);
	$user['avgping'] = round($user['avgping']);

	// Most played game check.
	$game = $db->query_first("
		SELECT COUNT(*) AS playcount, arcade_games.title
		FROM " . TABLE_PREFIX . "v3arcade_sessions AS arcade_sessions
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS arcade_games ON (arcade_games.gameid=arcade_sessions.gameid)
		WHERE start != 0
			AND finish != 0
			AND valid = 1 AND
			userid = " . $vbulletin->GPC['userid'] . "
		GROUP BY arcade_sessions.gameid
		ORDER BY playcount DESC
	");

	if ($user['playcount'])
	{
		$game['pcplayed'] = round(($game['playcount'] / $user['playcount']) * 100);
	}

	($hook = vBulletinHook::fetch_hook('arcade_miniuserinfo')) ? eval($hook) : false;

	eval('print_output("' . fetch_template('v3arcade_miniuserinfo') . '");');
}

// ############################################################################
// v3 Arcade 3.0.x LEGACY MODE - It could be prettier. But for the sake of
// backwards compatibility, it has to be this way!
// ############################################################################
if ($_REQUEST['sessdo'] == 'sessionstart')
{
	$vbulletin->input->clean_gpc('r', 'gamename', TYPE_NOHTML);

	$game = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "v3arcade_games
		WHERE shortname = '" . $db->escape_string($vbulletin->GPC['gamename']) . "'"
	);

	// A relic of insanity.
	if (!$game['gameid'])
	{
		exit;
	}

	($hook = vBulletinHook::fetch_hook('arcade_sessionstart')) ? eval($hook) : false;

	// Create an empty session record.
	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "v3arcade_sessions
			(gameid, gamename, userid, start, sessiontype, challengeid)
		VALUES (
			$game[gameid],
			'" . $db->escape_string($vbulletin->GPC['gamename']) . "',
			'" . $vbulletin->userinfo['userid'] . "',
			'" . TIMENOW . "',
			1,
			0
	)");

	// Fetch the ID number of the session we just inserted.
	$lastid = $db->insert_id();

	// Give Flash something to feast on.
	echo "&connStatus=1&initbar=" . rand(1, 10) . "&gametime=" . TIMENOW . "&lastid=$lastid&result=OK";
	echo '<META HTTP-EQUIV=Refresh CONTENT="0; URL=' . $vbulletin->options['bburl'] . '/arcade.php">';
	exit;
}

// ############################################################################
// PERMISSION REQUEST - Someone has a score to report.
// ############################################################################
if ($_REQUEST['sessdo'] == 'permrequest')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'note' => TYPE_NOHTML,
		'id' => TYPE_UINT,
		'gametime' => TYPE_UINT,
		'score' => TYPE_NOHTML,
		'key' => TYPE_UINT,
		'fakekey' => TYPE_UINT
	));

	if (!$vbulletin->GPC['note'] OR !$vbulletin->GPC['id'] OR !$vbulletin->GPC['fakekey'] OR !$vbulletin->GPC['gametime'])
	{
		exit;
	}

	$ceilscore = ceil($vbulletin->GPC['score']);
	$noteid = $vbulletin->GPC['note'] / ($vbulletin->GPC['fakekey'] * $ceilscore);

	if ($noteid != $vbulletin->GPC['id'])
	{
		echo '&validate=0';
		exit;
	}

	// Gets accurate timestamp
	$microone = getmicrotime();

	// Don't ask.
	if ($vbulletin->GPC['score'] == -1)
	{
		$vbulletin->GPC['score'] = 0;
	}

	($hook = vBulletinHook::fetch_hook('arcade_permrequest')) ? eval($hook) : false;

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "v3arcade_sessions SET
			score = '" . $db->escape_string($vbulletin->GPC['score']) . "',
			finish = '" . TIMENOW . "'
		WHERE sessionid = " . $vbulletin->GPC['id'] . "
			AND start = " . $vbulletin->GPC['gametime'] . "
			AND userid = " . $vbulletin->userinfo['userid']
	);

	build_arcade_latest();

	echo "&validate=1&microone=$microone&result=OK";
	exit;
}

// ############################################################################
// SUBMIT COMMENT - Accepts a user's comment post after playing a game.
// ############################################################################
if ($_REQUEST['do'] == 'commentsave')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'commenttext' => TYPE_NOCLEAN,
		'page' => TYPE_UINT,
		'sessionid' => TYPE_UINT,
		'tid' => TYPE_UINT
	));

	// Can this user post comments?
	if (!($permissions['arcadepermissions'] & $vbulletin->bf_ugp['arcadepermissions']['canpostcomments']))
	{
		print_no_permission();
	}

	$gamesession = $db->query_first("
		SELECT sessionid, userid, comment, gameid
		FROM " . TABLE_PREFIX . "v3arcade_sessions
		WHERE sessionid = " . $vbulletin->GPC['sessionid']
	);

	// Session doesn't exist.
	if (!$gamesession['sessionid'])
	{
		print_no_permission();
	}

	// Permission checking.
	if (!$gamesession['comment'])
	{
		// There's no comment, so check to see if this user can post a new one.
		if (!($permissions['arcadepermissions'] & $vbulletin->bf_ugp['arcadepermissions']['canpostcomments']))
		{
			print_no_permission();
		}
	}
	// The user wants to edit their own comment - can they?
	else if ($gamesession['userid'] == $vbulletin->userinfo['userid'] AND !($permissions['arcadepermissions'] & $vbulletin->bf_ugp['arcadepermissions']['caneditowncomments']))
	{
		print_no_permission();
	}
	// This crafty devil wants to edit someone else's comment.
	else if (!($permissions['arcadepermissions'] & $vbulletin->bf_ugp['arcadepermissions']['caneditanycomments']))
	{
		print_no_permission();
	}

	// If they used the original form, they shouldn't be able to submit anything longer than the max comment length.
	if (strlen($vbulletin->GPC['commenttext']) > $vbulletin->options['commentmaxlength'])
	{
		print_no_permission();
	}

	($hook = vBulletinHook::fetch_hook('arcade_commentsave')) ? eval($hook) : false;

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "v3arcade_sessions SET
			comment = '" . $db->escape_string($vbulletin->GPC['commenttext']) . "'
		WHERE sessionid = " . $vbulletin->GPC['sessionid']
	);

	$vbulletin->url = 'arcade.php?' . $vbulletin->session->vars['sessionurl'] . "do=scores&amp;gameid=$gamesession[gameid]&amp;page=" . $vbulletin->GPC['page'] . "&amp;sessionid=$gamesession[sessionid]&amp;tid=" . $vbulletin->GPC['tid'] . iif($vbulletin->options['scrolltoscore'], "#session$gamesession[sessionid]");
	eval(print_standard_redirect('v3_comment_saved'));
}

// ############################################################################
// COMMENT FETCH - Sending back data for editing purposes.
// ############################################################################
if ($_REQUEST['do'] == 'commentfetch')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'sessionid' => TYPE_UINT,
		'page' => TYPE_UINT
	));

	if ($game = $db->query_first("
		SELECT sessionid, comment
		FROM " . TABLE_PREFIX . "v3arcade_sessions
		WHERE sessionid = " . $vbulletin->GPC['sessionid']
	))
	{
		$page = $vbulletin->GPC['page'];
		eval('print_output("' . fetch_template('v3arcade_editcommentform') . '");');
	}

	print_no_permission();
}

// ############################################################################
// COMMENT/SCORE DELETE - Delete a game session.
// ############################################################################
if ($_REQUEST['do'] == 'commentdelete')
{
	$vbulletin->input->clean_gpc('r', 'sessionid', TYPE_UINT);

	// A quick definition.
	$newchampsql = '';

	$game = $db->query_first("
		SELECT arcade_sessions.sessionid, arcade_sessions.comment, arcade_sessions.gameid, arcade_sessions.score, arcade_sessions.userid, arcade_games.highscorerid, arcade_games.highscore
		FROM " . TABLE_PREFIX . "v3arcade_sessions AS arcade_sessions
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS arcade_games ON (arcade_games.gameid = arcade_sessions.gameid)
		WHERE sessionid = " . $vbulletin->GPC['sessionid']
	);

	if (!$game['gameid'])
	{
		eval(standard_error(fetch_error('invalid_x_specified', $vbphrase['game'])));
	}

	if ($game['userid'] == $vbulletin->userinfo['userid'])
	{
		// Okay, the current user is the owner of this score.
		if (!($permissions['arcadepermissions'] & $vbulletin->bf_ugp['arcadepermissions']['candeleteownscores']))
		{
			print_no_permission();
		}
	}
	else if (!($permissions['arcadepermissions'] & $vbulletin->bf_ugp['arcadepermissions']['candeleteanyscores']))
	{
		print_no_permission();
	}

	($hook = vBulletinHook::fetch_hook('arcade_commentdelete')) ? eval($hook) : false;

	// Well, we're still here. So:
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "v3arcade_sessions WHERE sessionid = " . $vbulletin->GPC['sessionid']);

	$buildchamps = false;
	if ($game['userid'] == $game['highscorerid'] AND $game['highscore'] == $game['score'])
	{
		// You know what? We just deleted the highest scorer for this game. Let's find the new champ.
		$buildchamps = true;

		if ($champcheck = $db->query_first("
			SELECT userid, score, finish
			FROM " . TABLE_PREFIX . "v3arcade_sessions
			WHERE valid = 1
				AND gameid = $game[gameid]
			ORDER BY score " . ($game['isreverse'] ? 'ASC' : 'DESC') . ", finish
		"))
		{
			$newchampsql = ", highscorerid=$champcheck[userid], highscore='$champcheck[score]', highscoredate='$champcheck[dateline]'";
		}
		else
		{
			// Just in case you just deleted the last score for this game. You know, it could happen.
			$newchampsql = ', highscorerid=0, highscore=0, highscoredate=0';
		}
	}

	// Reduce the session count for the game.
	$db->query_write("
		UPDATE " . TABLE_PREFIX . "v3arcade_games SET
			sessioncount = sessioncount-1
			$newchampsql
		WHERE gameid = $game[gameid]
	");

	if ($buildchamps)
	{
		build_arcade_champ_cache();
		build_arcade_award_cache();
	}

	$vbulletin->url = 'arcade.php?' . $vbulletin->session->vars['sessionurl'] . 'do=scores&amp;gameid=' . $game['gameid'];
	eval(print_standard_redirect('v3_comment_deleted'));
}

// #######################################################################
// START MAIN SCRIPT
// #######################################################################

// Make sure these phrases don't have quotes
$jsphrase = array(
	'add_favorite' => addcslashes($vbphrase['add_favorite'], '\''),
	'sub_favorite' => addcslashes($vbphrase['sub_favorite'], '\''),
	'are_you_sure' => addcslashes($vbphrase['are_you_sure'], '\''),
	'noresults' => addcslashes($vbphrase['noresults'], '\'')
);

eval('$arcade_headinclude = "' . fetch_template('v3arcade_headinclude') . '";');

// Alternate navbar template.
$navbartemplate = ($vbulletin->options['usealtnav']) ? 'v3arcade_navbar' : 'navbar';

// Alternate opacity for popup menus.
$vbulletin->options['popupopacityalt'] = $vbulletin->options['popupopacity'] / 100;

// Just in case.
$bitfieldcheck = '';

// Set here to easily pass info from inline moderation to $_REQUEST['do']==scores
$frominlinemod = false;

$footer = construct_phrase($vbphrase['arcade_end'], $vbulletin->options['arcadeimages']) . $footer;

// ############################################################################
// ARCADE_MAIN - There's no place like home.
// ############################################################################
if ($_REQUEST['do'] == 'home')
{
	// check before vB's clean_gpc() function sets it
	if (!isset($_REQUEST['categoryid']))
	{
		$_REQUEST['categoryid'] = $vbulletin->options['arcade_defaultcat'];
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'categoryid' => TYPE_INT,
		'pagenumber' => TYPE_UINT,
		'perpage' => TYPE_UINT
	));

	$categoryid = $vbulletin->GPC['categoryid'];
	$pagenumber = $vbulletin->GPC['pagenumber'];
	$perpage = $vbulletin->GPC['perpage'];

	// ##### BAR SWITCH - Makes that front page more (or less) crowded.
	if (isset($_GET['barsize']))
	{
		$barsize = $vbulletin->input->clean_gpc('r', 'barsize', TYPE_UINT);

		// Allows choosing the mini mode by default.
		if ($vbulletin->options['minibydefault'])
		{
			$barsize_c = ($barsize == 1) ? 0 : 1;
		}
		else
		{
			$barsize_c = $vbulletin->GPC['barsize'];
		}

		// Set the cookie so the new value is remembered.
		vbsetcookie('barsize', $barsize_c);
	}
	else
	{
		$vbulletin->input->clean_gpc('c', COOKIE_PREFIX . 'barsize', TYEP_UINT);

		// Simple variable names for cookies.
		$barsize = $vbulletin->GPC[COOKIE_PREFIX . 'barsize'];

		// Allows choosing the mini mode by default.
		if ($vbulletin->options['minibydefault'])
		{
			$barsize = ($barsize == 1) ? 0 : 1;
		}
	}

	$barsize = intval($barsize);

	// Set the viewing mode status icons.
	$barstatus[$barsize] = '_on';

	($hook = vBulletinHook::fetch_hook('arcade_main_start')) ? eval($hook) : false;

	// ##### Construct categories.
	$gamecategories = '';
	foreach (array(-1 => $vbphrase['allcategories'], 0 => $vbphrase['randomselection']) AS $id => $category)
	{
		exec_switch_bg();
		eval('$gamecategories .= "' . fetch_template(($id == $vbulletin->GPC['categoryid'] ? 'v3arcade_category_bit_active' : 'v3arcade_category_bit')) . '";');
	}

	foreach ($vbulletin->v3a_cats AS $id => $category)
	{
		exec_switch_bg();
		eval('$gamecategories .= "' . fetch_template(($id == $vbulletin->GPC['categoryid'] ? 'v3arcade_category_bit_active' : 'v3arcade_category_bit')) . '";');
	}

	$categoryname = ($vbulletin->GPC['categoryid']) ? $vbulletin->v3a_cats[$vbulletin->GPC['categoryid']] : $vbphrase['randomselection'];

	// Let's take care of what we're viewing now. (We use this for remembering the last page and category we were viewing.)
	set_bbarray_cookie('arcade_viewdata', 'categoryid', $vbulletin->GPC['categoryid']);
	set_bbarray_cookie('arcade_viewdata', 'pagenumber', iif($pagenumber, $pagenumber, 1));

	// set favorites
	$favcache = unserialize($vbulletin->userinfo['favcache']);
	if (!is_array($favcache))
	{
		$favcache = array();
	}

	// Only pull active games in queries if we're not an admin
	if (!($permissions['arcadepermissions'] & $vbulletin->bf_ugp['arcadepermissions']['canoverridepermissions']))
	{
		// Game bitfield check. (Is Active.)
		$bitfieldcheck = '(arcade_games.gamepermissions & ' . $vbulletin->bf_misc_gamepermissions['isactive'] . ')';
	}

	// ##### Playerbox
	$player = $vbulletin->userinfo; // to make things easier when userinfo starts flying everywhere. (Sorry Kier!)

	$show['avatar'] = true;
	$avatarurl = fetch_avatar_url($player['userid']);
	if ($avatarurl)
	{
		$player['avatarsize'] = $avatarurl[1];
		$player['avatarurl'] = $avatarurl[0];
	}
	else
	{
		$player['avatarurl'] = $vbulletin->options['arcadeimages'] . '/noavatar.gif';
	}

	// ##### Tournaments
	$show['tournaments'] = false;
	if ($vbulletin->options['tourmnt_enabled'] AND ($permissions['arcadetourperms'] & $vbulletin->bf_ugp['arcadetourperms']['canviewtourmnt']))
	{
		$show['tournaments'] = true;

		if (empty($vbulletin->v3a_tournament['tourdata']))
		{
			$vbulletin->v3a_tournament = build_tournament_cache();
		}

		$mosttourwins = $vbulletin->v3a_tournament['mostwins']['numwins'];
		$mosttour_winners = $vbulletin->v3a_tournament['mostwins']['winner'];

		$tourcounts = $vbulletin->v3a_tournament['tourdata'];
		$tourcounts['awaiting'] = vb_number_format($tourcounts['awaiting']);
		$tourcounts['active'] = vb_number_format($tourcounts['active']);
		$tourcounts['finished'] = vb_number_format($tourcounts['finished']);
		$tourcounts['total'] = vb_number_format($tourcounts['total']);

		// Tournaments for you to play in
		if ($vbulletin->userinfo['userid'])
		{
			$activetournaments = 0;
			$mytours = $db->query_read("
				SELECT arcade_tournamentplayers.tid, arcade_tournamentplayers.tries, arcade_tournamentplayers.round AS pround, arcade_tournaments.title, arcade_tournaments.numtries, arcade_tournaments.round, arcade_tournaments.status as tstatus
				FROM " . TABLE_PREFIX . "v3arcade_tournamentplayers AS arcade_tournamentplayers
				LEFT JOIN " . TABLE_PREFIX . "v3arcade_tournaments	AS arcade_tournaments ON (arcade_tournamentplayers.tid = arcade_tournaments.tid)
				WHERE arcade_tournamentplayers.userid = " . $vbulletin->userinfo['userid'] . "
					AND arcade_tournamentplayers.status = 0
					AND arcade_tournaments.status < 2
			");
			while ($tourrow = $db->fetch_array($mytours))
			{
				if (!$tourrow['tstatus'])
				{
					$waittournaments++;
				}
				else
				{
					$activetournaments++;
					if ($tourrow['tries'] < $tourrow['numtries'] AND $tourrow['pround'] == $tourrow['round'])
					{
						$tournamentlist .= '<a href="arcadetourmnt.php?' . $vbulletin->session->vars['sessionurl'] . 'do=viewtourmnt&amp;tid=' . $tourrow['tid'] . '">' . $tourrow['title'] . '</a><br />';
					}
				}
			}

			$db->free_result($mytours);
		}
	}

	// ##### Current Challenges.
	if ($vbulletin->userinfo['userid'])
	{
		$challenges = $db->query_read("
			SELECT arcade_challenges.*, touser.username AS tousername, fromuser.username AS fromusername, arcade_games.title
			FROM " . TABLE_PREFIX . "v3arcade_challenges AS arcade_challenges
			LEFT JOIN " . TABLE_PREFIX . "user AS touser ON (touser.userid = arcade_challenges.touserid)
			LEFT JOIN " . TABLE_PREFIX . "user AS fromuser ON (fromuser.userid = arcade_challenges.fromuserid)
			LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS arcade_games ON (arcade_games.gameid = arcade_challenges.gameid)
			WHERE (status = 0 AND touserid = " . $vbulletin->userinfo['userid'] . ")
				OR (status = 1 AND touserid = " . $vbulletin->userinfo['userid'] . " AND tosessionid = 0)
				OR (status = 1 AND fromuserid = " . $vbulletin->userinfo['userid'] . " AND fromsessionid = 0)
		");
		while ($challenge = $db->fetch_array($challenges))
		{
			// true = Challenger
			// false = Challenged
			$challenge['stance'] = ($vbulletin->userinfo['userid'] == $challenge['touserid']) ? false : true;

			if ($challenge['stance'])
			{
				$challenge['username'] = $challenge['tousername'];
				$challenge['userid'] = $challenge['touserid'];
			}
			else
			{
				$challenge['username'] = $challenge['fromusername'];
				$challenge['userid'] = $challenge['fromuserid'];
			}

			eval('$challengebits .= "' . fetch_template('v3arcade_challenge_bit') . '";');
		}
	}

	// ##### Fetch the latest news.
	$newsbits = '';
	if ($vbulletin->options['arcade_newslimit'])
	{
		// simple auto update if the setting's changed
		if ($vbulletin->options['arcade_newslimit'] != $vbulletin->v3a_news['newslimit'])
		{
			$vbulletin->v3a_news = build_arcade_news_cache();
		}

		// loop through news events
		if (!empty($vbulletin->v3a_news['newsevents']))
		{
			foreach ($vbulletin->v3a_news['newsevents'] AS $news)
			{
				exec_switch_bg();
				$news['date'] = vbdate($vbulletin->options['logdateformat'], $news['datestamp']);
				eval('$newsbits .= "' . fetch_template('v3arcade_news_bit') . '";');
			}
		}
	}

	$mcbits = '';

	if ($vbulletin->options['frontminichallenges'] != $vbulletin->v3a_challenge['challengelimit'])
	{
		$vbulletin->v3a_challenge = build_finished_challenge_cache();
	}

	// ##### Recent finished challenges
	if (!empty($vbulletin->v3a_challenge['challenges']))
	{
		foreach ($vbulletin->v3a_challenge['challenges'] AS $challengeid => $challenge)
		{
			exec_switch_bg();
			$challenge['toscore'] = vb_number_format($challenge['toscore']);
			$challenge['fromscore'] = vb_number_format($challenge['fromscore']);

			eval('$mcbits .= "' . fetch_template('v3arcade_challenge_minibit') . '";');
		}
	}

	// ##### Arcade Champions
	$arcadechamps = '';
	$show['lb_link'] = false;
	if ($vbulletin->options['arcadechamps'] AND !empty($vbulletin->v3a_champs))
	{
		if ($vbulletin->options['arcadeleaders'] AND sizeof($vbulletin->v3a_champs) > $vbulletin->options['arcadechamps'])
		{
			$show['lb_link'] = true;
		}
		
		foreach (array_slice($vbulletin->v3a_champs, 0, $vbulletin->options['arcadechamps']) AS $champs)
		{
			eval('$arcadechamps .= "' . fetch_template('v3arcade_main_champbits') . '";');
		}
	}

	// ##### Latest scores
	$scorebits = '';
	if ($vbulletin->options['arcadelatescores'])
	{
		// simple auto update if the setting's changed
		if ($vbulletin->options['arcadelatescores'] != $vbulletin->v3a_newscores['scoreslimit'])
		{
			$vbulletin->v3a_newscores = build_arcade_latest();
		}

		// loop through our scores
		if (!empty($vbulletin->v3a_newscores['scores']))
		{
			foreach ($vbulletin->v3a_newscores['scores'] AS $late)
			{
				eval('$latestscorebits .= "' . fetch_template('v3arcade_main_latestscores') . '";');
			}
		}
	}


	// ##### Let the games begin!
	$gamebits = '';
	// No category id, so show a random selection of games.
	if (!$vbulletin->GPC['categoryid'])
	{
		$games = $db->query_read("
			SELECT arcade_games.*, user.username, arcade_categories.catname
			FROM " . TABLE_PREFIX . "v3arcade_games AS arcade_games
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (arcade_games.highscorerid = user.userid)
			LEFT JOIN " . TABLE_PREFIX . "v3arcade_categories AS arcade_categories ON (arcade_games.categoryid = arcade_categories.categoryid)
			" . iif($bitfieldcheck, "WHERE $bitfieldcheck") . "
			ORDER BY RAND()
			LIMIT " . $vbulletin->options['gamesperpage']
		);
	}
	// Favorites
	else if ($vbulletin->GPC['categoryid'] == 2)
	{
		$gamecount = sizeof($favcache);

		if ($gamecount)
		{
			// set defaults
			sanitize_pageresults($gamecount, $pagenumber, $perpage, 100, $vbulletin->options['gamesperpage']);

			$start = (int)($perpage * $pagenumber) - $perpage;

			$games = $db->query_read("
				SELECT arcade_games.*, user.username, arcade_categories.catname
				FROM " . TABLE_PREFIX . "v3arcade_games AS arcade_games
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON (arcade_games.highscorerid = user.userid)
				LEFT JOIN " . TABLE_PREFIX . "v3arcade_categories AS arcade_categories ON (arcade_games.categoryid = arcade_categories.categoryid)
				WHERE arcade_games.gameid IN (" . implode(',', $favcache) . ")
					" . iif($bitfieldcheck, 'AND ' . $bitfieldcheck) . "
				LIMIT $start, " . $vbulletin->options['gamesperpage']
			);
		}
	}
	// Get games only from the specified category id.
	else
	{
		$querywhere = '';
		if ($vbulletin->GPC['categoryid'] != -1)
		{
			$querywhere = 'arcade_games.categoryid = ' . $vbulletin->GPC['categoryid'];
		}
		if ($bitfieldcheck)
		{
			$querywhere = ($querywhere ? $querywhere . ' AND ' : '') . $bitfieldcheck;
		}

		if ($querywhere)
		{
			$querywhere = 'WHERE ' . $querywhere;
		}

		// First of all, get a total game count.
		$countquery = $db->query_first("
			SELECT COUNT(*) AS gamecount
			FROM " . TABLE_PREFIX . "v3arcade_games AS arcade_games
			$querywhere
		");
		$gamecount = $countquery['gamecount'];

		// set defaults
		sanitize_pageresults($gamecount, $pagenumber, $perpage, 100, $vbulletin->options['gamesperpage']);

		$start = (int)($perpage*$pagenumber)-$perpage;

		$games = $db->query_read("
			SELECT arcade_games.*, user.username, arcade_categories.catname
			FROM " . TABLE_PREFIX . "v3arcade_games AS arcade_games
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (arcade_games.highscorerid = user.userid)
			LEFT JOIN " . TABLE_PREFIX . "v3arcade_categories AS arcade_categories ON (arcade_games.categoryid = arcade_categories.categoryid)
			$querywhere
			ORDER BY title ASC
			LIMIT $start, " . $vbulletin->options['gamesperpage']
		);
	}

	if ($db->num_rows($games))
	{
		// Page navigation
		if ($vbulletin->GPC['categoryid'])
		{
			$pagenav = construct_page_nav(
				$pagenumber,
				$perpage,
				$gamecount,
				'arcade.php?' . $vbulletin->session->vars['sessionurl'],
				($vbulletin->GPC['categoryid'] ? '&amp;categoryid=' . $vbulletin->GPC['categoryid'] : '')
				. ($vbulletin->GPC['perpage'] ? '&amp;pp=' . $perpage : '')
			);
		}

		// Game cache contains all the data we need to populate the game row - image links, titles, descriptions, etc.
		$gamecache = array();

		while ($game = $db->fetch_array($games))
		{
			/* Now, because we need to use this data to let us know which games to get score data for,
			we're caching it here rather than spitting out the game rows. */
			$gamecache[$game['gameid']] = $game;
		}

		// Only bother with high scores if the user is actually logged in.
		if ($vbulletin->userinfo['userid'])
		{
			$scoredata = $db->query_read("
				SELECT MAX(score) AS personalbest, MIN(score) AS personalbestr, gameid
				FROM " . TABLE_PREFIX . "v3arcade_sessions
				WHERE gameid IN (" . implode(',', array_keys($gamecache)) . ")
					AND userid = " . $vbulletin->userinfo['userid'] . "
				GROUP BY gameid
			");
			while ($score = $db->fetch_array($scoredata))
			{
				// Add this data to the $gamecache array
				$gamecache[$score['gameid']]['personalbest'] = ($gamecache[$score['gameid']]['isreverse'] ? $score['personalbestr'] : $score['personalbest']);
			}
		}

		$gamebit_tempname = ($barsize) ? 'v3arcade_game_bit_slim' : 'v3arcade_game_bit';

		// Now we can use $gamecache to populate our game section.
		foreach ($gamecache as $key => $game)
		{
			exec_switch_bg();

			$show['rating'] = false;
			if ($game['votecount'])
			{
				$game['rating_acc'] = round(($game['votepoints'] / $game['votecount']), 2);
				$game['rating'] = ceil($game['rating_acc']);
				$show['rating'] = true;
			}

			$show['fav'] = $favcache[$game['gameid']];

			$game['awardimg'] = arcade_award_img($game);

			($hook = vBulletinHook::fetch_hook('arcade_game_bit')) ? eval($hook) : false;

			// set these below the hook incase anyone needs to do raw score comparing
			$game['highscore'] = v3_score_format($game['highscore']);
			$game['personalbest'] = vb_number_format($game['personalbest']);

			eval('$gamebits .= "' . fetch_template($gamebit_tempname) . '";');
		}
	}

	// Start the navbar
	$navbits[''] = $vbulletin->options['arcadename'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template($navbartemplate) . '";');

	($hook = vBulletinHook::fetch_hook('arcade_main_complete')) ? eval($hook) : false;

	eval('print_output("' . fetch_template('v3ARCADE_MAIN') . '");');
}

// ############################################################################
// Play a game
// ############################################################################
if ($_REQUEST['do'] == 'play')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'challengeid' => TYPE_UINT,
		'gameid' => TYPE_UINT,
		'resolution' => TYPE_INT,
		'tid' => TYPE_UINT
	));

	// Can this user play?
	if (!($permissions['arcadepermissions'] & $vbulletin->bf_ugp['arcadepermissions']['canplayarcade']))
	{
		print_no_permission();
	}

	// ##### Challenge!
	if ($vbulletin->GPC['challengeid'])
	{
		// This is a challenge, so we'll use the game ID from there instead.
		$challenge = $db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "v3arcade_challenges
			WHERE challengeid = " . $vbulletin->GPC['challengeid']
		);

		if (!$challenge['challengeid'])
		{
			eval(standard_error(fetch_error('invalid_x_specified', $vbphrase['challenge'])));
		}

		// 1 = Challenger
		// 0 = Challenged
		$challenge['stance'] = ($vbulletin->userinfo['userid'] == $challenge['touserid']) ? 0 : 1;

		// A little security.
		if ($challenge['stance'] AND $vbulletin->userinfo['userid'] != $challenge['fromuserid'])
		{
			// This user has nothing to do with this challenge.
			print_no_permission();
		}

		if (!$challenge['status'] AND $challenge['stance'])
		{
			// The challenger has submitted a new challenge.
			$vbulletin->url = 'arcade.php' . $vbulletin->session->vars['sessionurl_q'];
			eval(print_standard_redirect('v3_challenge_submitted'));
		}

		// The challenged user has ACCEPTED, and is now playing.
		if (!$challenge['status'])
		{
			$challenge['status'] = 1;

			// Update the challenge record.
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "v3arcade_challenges SET
					status = 1
				WHERE challengeid=" . $challenge['challengeid']
			);

			$otheruser = fetch_userinfo($challenge['fromuserid']);

			if ($otheruser['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['challengeaccepted'])
			{
				if ($otheruser['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['useemail'])
				{
					vbmail($otheruser['email'],
					construct_phrase($vbphrase['challenge_accepted_t'], $vbulletin->userinfo['username']),
					construct_phrase($vbphrase['challenge_accepted_e'], $vbulletin->userinfo['username'], $vbulletin->options['bburl'] . '/arcade.php?do=play&challengeid=' .$challenge['challengeid'])
					);
				}

				if ($otheruser['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['usepms'])
				{
					// Override a potentially full inbox.
					$senderpermissions['adminpermissions'] = 2;

					$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
					$pmdm->set_info('is_automated', true);
					$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
					$pmdm->set('fromusername', $vbulletin->userinfo['username']);
					$pmdm->set('title', construct_phrase($vbphrase['challenge_accepted_t'], $vbulletin->userinfo['username']));
					$pmdm->set('message', construct_phrase($vbphrase['challenge_accepted_p'], $vbulletin->userinfo['username'], $vbulletin->options['bburl'] . '/arcade.php?do=play&challengeid=' .$challenge['challengeid']));
					$pmdm->set_recipients($otheruser['username'], $senderpermissions);
					$pmdm->set('dateline', TIMENOW);

					$pmdm->save();
				}
			}
		}
		// Don't let them play again if they hit back & refresh... gotta try harder than that now
		else if ($vbulletin->userinfo['userid'] == $challenge['touserid'] OR $challenge['status'] > 1)
		{
			eval(standard_error(fetch_error('v3_challenge_cant_play_twice')));
		}

		// The user can play.
		if ($vbulletin->userinfo['challengecache'] == $challenge['challengeid'])
		{
			// This user has tried to play this challenge before, and they're trying again. :\
			eval(standard_error(fetch_error('v3_challenge_cant_play_twice')));
		}

		// Save the challenge id. We need to know that their next score is going to be associated with this challenge.
		// We're doing this in the database because we can't count on cookies being enabled.
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "user SET
				challengecache = $challenge[challengeid]
			WHERE userid = " . $vbulletin->userinfo['userid']
		);

		$vbulletin->GPC['gameid'] = $challenge['gameid'];
		$show['challenge'] = true;

		// Avatar processing.
		$challenger['avatar'] = fetch_avatar_url(($vbulletin->userinfo['userid'] == $challenge['touserid'] ? $challenge['fromuserid'] : $challenge['touserid']));
		$challenger['useravatar'] = $challenger['avatar'][0];
		$challenger['avdimensions'] = $challenger['avatar'][1];
		if (!$challenger['useravatar'])
		{
			$challenger['useravatar'] = $vbulletin->options['arcadeimages'] . '/noavatar.gif';
		}
	} // End Challenge Code

	$arcadeadmin = ($permissions['arcadepermissions'] & $vbulletin->bf_ugp['arcadepermissions']['canoverridepermissions']);

	$game = $db->query_first("
		SELECT arcade_games.*, user.username, user.userid AS ouserid
		FROM " . TABLE_PREFIX . "v3arcade_games AS arcade_games
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = " . iif($vbulletin->GPC['challengeid'], iif($vbulletin->userinfo['userid'] == $challenge['touserid'], $challenge['fromuserid'], $challenge['touserid']), 'arcade_games.highscorerid') . ")
		WHERE gameid = " . $vbulletin->GPC['gameid']
		 . iif(!$arcadeadmin, ' AND (gamepermissions & ' . $vbulletin->bf_misc_gamepermissions['isactive'] . ')')
	);

	if (!$game['gameid'])
	{
		eval(standard_error(fetch_error('invalid_x_specified', $vbphrase['game'])));
	}

	// ##### Start Permission Checks
	check_canplay($game);

	$templatename = 'v3ARCADE_PLAY';

	// This hook is before the user plays, but *not* if they're responding to a challenge.
	($hook = vBulletinHook::fetch_hook('arcade_play')) ? eval($hook) : false;

	// ##### Tournament Stuff
	if ($vbulletin->options['tourmnt_enabled'] AND $vbulletin->GPC['tid'] AND !$vbulletin->GPC['challengeid'])
	{
		// Don't do anything if challengeid is set, it shouldn't if everything is correct.
		$tournament = $db->query_first("
			SELECT arcade_tournaments.*, user.username, arcade_games.title AS a_gametitle, arcade_games.isreverse
			FROM " . TABLE_PREFIX . "v3arcade_tournaments AS arcade_tournaments
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_tournaments.creator)
			LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS arcade_games ON (arcade_games.gameid = arcade_tournaments.gameid)
			WHERE tid = " . $vbulletin->GPC['tid']
		);

		if (!$tournament['tid'])
		{
			eval(standard_error(fetch_error('invalid_x_specified', $vbphrase['tournament'])));
		}

		// Do some checks to see if everything is ok. Same gameid, no open slots left, no winner set, round can't be 0, not already playing
		if ($tournament['gameid'] != $vbulletin->GPC['gameid'] OR $tournament['openslots'] OR $tournament['winner'] OR !$tournament['round'])
		{
			// Something is wrong, just do a no permission to end things.
			print_no_permission();
		}

		$show['tournament'] = true;

		// Use the arcade gametitle if there is any.
		if ($tournament['a_gametitle'])
		{
			$tournament['gametitle'] = $tournament['a_gametitle'];
		}

		// Get info about the player games and scores
		$playerresult = $db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "v3arcade_tournamentplayers
			WHERE userid = " . $vbulletin->userinfo['userid'] . "
				AND status < 40
				AND tid = " . $vbulletin->GPC['tid']
		);

		if (!$db->num_rows($playerresult))
		{
			print_no_permission();
		}

		$playerinfo = array();

		while ($round = $db->fetch_array($playerresult))
		{
			$playerinfo[$round['round']] = $round;
		}

		$currentround = $playerinfo[$tournament['round']];

		$db->free_result($playerresult);

		if ($currentround['tries'] >= $tournament['numtries'])
		{
			// No tries left in this round
			eval(standard_error(fetch_error('v3_no_attempts_left_in_round')));
		}

		$tournament['round'] = $vbphrase['roundstatus_' . $tournament['round']]; // Change number to someting understandable.

		$currentround['tries']++; // Add 1 for this is one try

		if (!isset($currentround['score']))
		{
			$currentround['score'] = $vbphrase['n_a'];
		}
		else
		{
			$currentround['score'] = v3_score_format($currentround['score']);
		}

		// Update number of tries, date and set flag that the player is playing
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "v3arcade_tournamentplayers SET
				tries = tries+1,
				playing = 1,
				datestamp = " . TIMENOW . "
			WHERE tpid = $currentround[tpid]
		");

		// Set flag user database so we know that it has been a tournament game when returning from flash
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "user SET
				tournamentid_playing = " . $vbulletin->GPC['tid'] . "
			WHERE userid = " . $vbulletin->userinfo['userid']
		);
	}

	$resolution = 100;

	// Not a challenge, so we need a little more info
	if (!$vbulletin->GPC['challengeid'])
	{
		$game['highscore'] = v3_score_format($game['highscore']);
		$game['awardimg'] = arcade_award_img($game);
	}

	// Game resolution
	if ($vbulletin->options['arcaderesolutions'])
	{
		$resarray = explode(', ', $vbulletin->options['arcaderesolutions']);
		$res_dropbits = '';

		if (!empty($resarray))
		{
			if (!$vbulletin->GPC['resolution'])
			{
				$vbulletin->GPC['resolution'] = 100;
			}

			foreach ($resarray AS $key => $res)
			{
				$gowidth = round($game['width'] * ($res / 100));
				$goheight = round($game['height'] * ($res / 100));

				eval('$res_dropbits .= "' . fetch_template('v3arcade_play_resolutionbits') . '";');
			}

			if ($vbulletin->GPC['resolution'] AND in_array($vbulletin->GPC['resolution'], $resarray))
			{
				$resolution = $vbulletin->GPC['resolution'];
				$game['width'] = round($game['width'] * ($vbulletin->GPC['resolution'] / 100));
				$game['height'] = round($game['height'] * ($vbulletin->GPC['resolution'] / 100));
			}
		}
	}

	// Use the correct flash code depending on the game system.
	switch ($game['system'])
	{
		case 0: // v3 Arcade Legacy Title
		case 10: // iB Arcade Legacy Title (The same for the time being)
			eval('$flashcode = "' . fetch_template('v3arcade_play_v3game') . '";');
		break;

		case 99:

			if (!$vbulletin->userinfo['userid'])
			{
				// make the phrase javascript friendly
				$vbphrase['score_not_registered_js'] = addslashes(str_replace("\r\n", ' ', $vbphrase['score_not_registered']));
			}

			eval('$flashcode = "' . fetch_template('v3arcade_play_mochigame') . '";');
		break;
	}

	if ($vbulletin->userinfo['userid'])
	{
		$pbest = $db->query_first("
			SELECT sessionid, score
			FROM " . TABLE_PREFIX . "v3arcade_sessions
			WHERE valid = 1
				AND gameid = $game[gameid]
				AND userid = " . $vbulletin->userinfo['userid'] . "
			ORDER BY score " . ($game['isreverse'] ? 'ASC' : 'DESC')
		);

		if ($pbest['sessionid'])
		{
			$show['pbest'] = true;
			$pbest['score'] = v3_score_format($pbest['score']);
		}
	}

	// navbar
	$navbits['arcade.php' . $vbulletin->session->vars['sessionurl_q']] = $vbulletin->options['arcadename'];
	$navbits[''] = $game['title'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template($navbartemplate) . '";');

	eval('print_output("' . fetch_template($templatename) . '");');
}

// ############################################################################
// Save Mochiads session
// ############################################################################
if ($_REQUEST['sessdo'] == 'mochiburn' AND $_POST['signature'] AND ($_SERVER['HTTP_REFERER'] == 'http://x.mochiads.com/mochiBridge/' . $vbulletin->options['arcademochi'] OR $_SERVER['HTTP_REFERER'] == 'http://x.mochimedia.com/mochiBridge/' . $vbulletin->options['arcademochi']))
{
	$vbulletin->input->clean_array_gpc('p', array(
		'score' => TYPE_NOHTML,
		'sessionID' => TYPE_UINT,
		'userID' => TYPE_UINT
	));

	// Make sure the game exists
	if(!$game = $db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "v3arcade_games
			WHERE gameid = '" . $db->escape_string($vbulletin->GPC['sessionID']) . "'
		")
	)
	{
		exit;
	}

	if ($game['gamepermissions'] & $vbulletin->bf_misc_gamepermissions['disablescoring'])
	{
		exit;
	}

	$sigcheck = md5($mochisigcheck . $vbulletin->options['arcademochi_secret']);

	if ($sigcheck == $_POST['signature'])
	{
		// Create a session record.
		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "v3arcade_sessions
				(gameid, gamename, userid, start, sessiontype, challengeid, score, finish)
			VALUES (
				$game[gameid],
				'" . $db->escape_string($game['shortname']) . "',
				'" . $vbulletin->GPC['userID'] . "',
				" . TIMENOW . ",
				1,
				" . ($vbulletin->userinfo['challengecache'] ? $vbulletin->userinfo['challengecache'] : 0) . ",
				'" . $db->escape_string($vbulletin->GPC['score']) . "',
				" . TIMENOW . "
		)");
	}
}

// ############################################################################
// BURN SESSION - So called because we're validating this session.
// ############################################################################
if ($_REQUEST['sessdo'] == 'burn')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'id' => TYPE_UINT,
		'microone' => TYPE_NUM,
		'mochigame' => TYPE_UINT
	));

	$tourid = 0;

	// Mochiads game
	if ($vbulletin->GPC['mochigame'])
	{
		$game = $db->query_first("
			SELECT arcade_sessions.*, arcade_games.*
			FROM " . TABLE_PREFIX . "v3arcade_sessions AS arcade_sessions
			LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS arcade_games ON (arcade_games.gameid = arcade_sessions.gameid)
			WHERE arcade_sessions.gameid = " . $vbulletin->GPC['mochigame'] . "
				AND arcade_sessions.userid = " . $vbulletin->userinfo['userid'] . "
			ORDER BY sessionid DESC
		");
		$vbulletin->GPC['id'] = $game['sessionid'];
	}
	// Any other game
	else
	{
		$game = $db->query_first("
			SELECT arcade_sessions.*, arcade_games.*
			FROM " . TABLE_PREFIX . "v3arcade_sessions AS arcade_sessions
			LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS arcade_games ON (arcade_games.gameid = arcade_sessions.gameid)
			WHERE sessionid = " . $vbulletin->GPC['id']
		);
	}

	// Scoring is disabled for this game, thanks for playing!
	if ($game['gamepermissions'] & $vbulletin->bf_misc_gamepermissions['disablescoring'])
	{
		eval(standard_error(construct_phrase($vbphrase['thanks_for_playing_x'], $game['title'])));
	}

	// Show them the door, since the session doesn't exist or it doesn't belong to them.
	if (!$game['sessionid'] OR $game['userid'] != $vbulletin->userinfo['userid'] OR $game['ping'] > 0) // ping should be 0.00
	{
		print_no_permission();
	}

	// Get category and page history data.
	$catpagedata = findcatpage();

	if ($game['votecount'])
	{
		$game['rating_acc'] = round(($game['votepoints'] / $game['votecount']), 2);
		$game['rating'] = ceil($game['rating_acc']);
	}

	($hook = vBulletinHook::fetch_hook('arcade_burn')) ? eval($hook) : false;

	$show['tournamentbox'] = false;
	// It has been a tournament game and first time here.
	if ($vbulletin->options['tourmnt_enabled'] AND $vbulletin->userinfo['tournamentid_playing'])
	{
		// Get tournament info
		$tournament = $db->query_first("
			SELECT arcade_tournaments.*, user.username, arcade_games.title AS a_gametitle, arcade_games.isreverse
			FROM " . TABLE_PREFIX . "v3arcade_tournaments AS arcade_tournaments
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_tournaments.creator)
			LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS arcade_games ON (arcade_games.gameid = arcade_tournaments.gameid)
			WHERE tid = " . $vbulletin->userinfo['tournamentid_playing']
		);
		if ($tournament['tid'])
		{
			$tourid = $tournament['tid'];
			
			// Do some checks to see if everything is ok. Same gameid, no open slots left, no winner set, round can't be 0
			if ($tournament['gameid'] == $game['gameid'] AND !$tournament['openslots'] AND !$tournament['winner'] AND $tournament['round'])
			{
				// Use the arcade gametitle if there is any.
				if ($tournament['a_gametitle'])
				{
					$tournament['gametitle'] = $tournament['a_gametitle'];
				}

				// Get info about this round
				$playerresult = $db->query_read("
					SELECT arcade_tournamentplayers.*, user.arcadeoptions, user.email, user.username
					FROM " . TABLE_PREFIX . "v3arcade_tournamentplayers AS arcade_tournamentplayers
					LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_tournamentplayers.userid)
					WHERE round = $tournament[round]
						AND tid = " . $vbulletin->userinfo['tournamentid_playing'] . "
					ORDER BY slot ASC
				");
				if ($db->num_rows($playerresult))
				{
					$slots = array();
					while($slot = $db->fetch_array($playerresult))
					{
						$slots[$slot['slot']] = $slot;
						if ($slot['userid'] == $vbulletin->userinfo['userid'])
						{
							$thisplayer = $slot;
						}
					}

					$db->free_result($playerresult);

					if ($thisplayer['playing'] == 1 AND $thisplayer['tries'] <= $tournament['numtries'])
					{
						$show['tournamentbox'] = true;

						// It seems everything is OK, save the best score. Also clear playing flag
						if (isset($thisplayer['score']))
						{
							if ($game['score'] > $thisplayer['score'])
							{
								$thisplayer['score'] = ($tournament['isreverse']) ? $thisplayer['score'] : $game['score'];
							}
							else
							{
								$thisplayer['score'] = ($tournament['isreverse']) ? $game['score'] : $thisplayer['score'];
							}
						}
						else
						{
							$thisplayer['score'] = $game['score'];
						}

						$db->query_write("
							UPDATE " . TABLE_PREFIX . "v3arcade_tournamentplayers SET
								score = '" . $thisplayer['score'] . "',
								playing = ''
							WHERE tpid = $thisplayer[tpid]
						");

						$thisplayer['playing'] = 0;

						if ($thisplayer['tries'] == $tournament['numtries'])
						{
							// Last try for the player, lets see if we can declare a winner
							$thisplayer['last'] = true;

							require_once(DIR . '/includes/v3arcade_functions_tourmnt.php');
							$cmpret = compare_slots($tournament, $thisplayer, $slots);
						}
					}

					// Clear cache in user database
					$db->query_write("
						UPDATE " . TABLE_PREFIX . "user SET
							tournamentid_playing = ''
						WHERE userid = " . $vbulletin->userinfo['userid']
					);

				}
			}
		}
	}

	// If someone is registered, let them rate games
	if ($vbulletin->userinfo['userid'])
	{
		// Get this user's rating for the current game, if they voted.
		$favcache = unserialize($vbulletin->userinfo['favcache']);
		$show['fav'] = ($favcache[$game['gameid']]);
		$show['rating'] = true;

		$show['favorites'] = $vbulletin->options['arcade_favs'];

		if ($userrating = $db->query_first("
			SELECT rating
			FROM " . TABLE_PREFIX . "v3arcade_ratings
			WHERE gameid = $game[gameid]
				AND userid = " . $vbulletin->userinfo['userid']
		))
		{
			$game['initrating'] = 'starover(' . $userrating['rating'] . '); enablerating=0;';
		}
	}

	// Show context-sensitive elements.

	// Can this user post comments?
	$show['commentbox'] = ($permissions['arcadepermissions'] & $vbulletin->bf_ugp['arcadepermissions']['canpostcomments']);

	$show['thanksforplaying'] = true;

	// We're going to need to parse the comment text.
	require_once(DIR . '/includes/class_bbcode.php');
	$parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

	// Misc. variable setting.
	$placecounter = 1;
	$ranking = 0;
	$scorebits = '';
	$highnotify = false;
	$difference = sprintf('%.1f', (getmicrotime() - ($vbulletin->GPC['mochigame'] ? TIMENOW : $vbulletin->GPC['microone'])) / 2 * 1000);

	// Did a guest just play this game?
	if (!$vbulletin->userinfo['userid'])
	{
		$show['guestscore'] = true;
	}
	else
	{
		// A registered user scored something, so let's make it count!
		// Pings greater than 4500ms don't count.
		if ($difference > 4500)
		{
			$validate = 0;
			print_no_permission();
		}
		else
		{
			$validate = 1;
			// Increase the valid session count.
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "v3arcade_games SET
					sessioncount = sessioncount+1
				WHERE gameid = $game[gameid]
			");
		}

		// Save the session.
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "v3arcade_sessions SET
				ping = '$difference',
				valid = $validate,
				tourid = $tourid
			WHERE sessionid = " . $vbulletin->GPC['id'] . "
				AND userid = " . $vbulletin->userinfo['userid']
		);

		if ($validate)
		{
			build_arcade_latest();
		}
	}

	// Is this a challenge?
	if ($vbulletin->userinfo['challengecache'])
	{
		$challenge = $db->query_first("
			SELECT arcade_challenges.*, touser.arcadeoptions AS toarcadeoptions, fromuser.arcadeoptions AS fromarcadeoptions, touser.email AS toemail, fromuser.email AS fromemail, touser.username AS tousername, fromuser.username AS fromusername
			FROM " . TABLE_PREFIX . "v3arcade_challenges AS arcade_challenges
			LEFT JOIN " . TABLE_PREFIX . "user AS touser ON (touser.userid = arcade_challenges.touserid)
			LEFT JOIN " . TABLE_PREFIX . "user AS fromuser ON (fromuser.userid = arcade_challenges.fromuserid)
			WHERE challengeid = " . $vbulletin->userinfo['challengecache']
		);
		// 1 = Challenger
		// 0 = Challenged
		$challenge['stance'] = ($vbulletin->userinfo['userid'] == $challenge['touserid']) ? false : true;

		if ($challenge['gameid'] == $game['gameid'])
		{
			// It's the same game, so it's valid.
			if ($challenge['stance'])
			{
				$challenge['fromscore'] = $game['score'];
				$challenge['fromsessionid'] = $vbulletin->GPC['id'];

				$db->query_write("
					UPDATE " . TABLE_PREFIX . "v3arcade_challenges SET
						fromsessionid = " . $vbulletin->GPC['id'] . ",
						fromscore = '$game[score]'
					WHERE challengeid = " . $challenge['challengeid']
				);
			}
			else
			{
				$challenge['toscore'] = $game['score'];
				$challenge['tosessionid'] = $vbulletin->GPC['id'];

				$db->query_write("
					UPDATE " . TABLE_PREFIX . "v3arcade_challenges SET
						tosessionid = " . $vbulletin->GPC['id'] . ",
						toscore = '$game[score]'
					WHERE challengeid = " . $challenge['challengeid']
				);
			}

			// Clear the cache.
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "user SET
					challengecache = ''
				WHERE userid = " . $vbulletin->userinfo['userid']
			);

			if ($challenge['tosessionid'] AND $challenge['fromsessionid'])
			{
				// Both scores are in!
				if ($challenge['fromscore'] > $challenge['toscore'])
				{
					$challenge['winnerid'] = ($game['isreverse']) ? $challenge['touserid'] : $challenge['fromuserid'];
					$challenge['loserid'] = (!$game['isreverse']) ? $challenge['touserid'] : $challenge['fromuserid'];
				}
				else
				{
					$challenge['winnerid'] = (!$game['isreverse']) ? $challenge['touserid'] : $challenge['fromuserid'];
					$challenge['loserid'] = ($game['isreverse']) ? $challenge['touserid'] : $challenge['fromuserid'];
				}

				// Challenge complete.
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "v3arcade_challenges SET
						winnerid = $challenge[winnerid],
						loserid = $challenge[loserid],
						status = 3
					WHERE challengeid = " . $challenge['challengeid']
				);

				build_finished_challenge_cache();

				$show['challengeresults'] = true;

				if($vbulletin->userinfo['userid'] == $challenge['touserid'])
				{
					$otheruser['options'] = $challenge['fromarcadeoptions'];
					$otheruser['email'] = $challenge['fromemail'];
					$otheruser['username'] = $challenge['fromusername'];
				}
				else
				{
					$otheruser['options'] = $challenge['toarcadeoptions'];
					$otheruser['email'] = $challenge['toemail'];
					$otheruser['username'] = $challenge['tousername'];
				}

				if ($otheruser['options'] & $vbulletin->bf_misc_arcadeoptions['finishedchallenge'])
				{
					$challenge['fromscore'] = v3_score_format($challenge['fromscore']);
					$challenge['toscore'] = v3_score_format($challenge['toscore']);

					if ($otheruser['options'] & $vbulletin->bf_misc_arcadeoptions['useemail'])
					{
						vbmail($otheruser['email'],
							construct_phrase($vbphrase['challenge_results_t'], $challenge['fromusername'], $challenge['tousername']),
							construct_phrase($vbphrase['challenge_results_e'], $challenge['fromusername'], $challenge['fromscore'], $challenge['tousername'], $challenge['toscore'])
						);
					}

					if ($otheruser['options'] & $vbulletin->bf_misc_arcadeoptions['usepms'])
					{
						// Override a potentially full inbox.
						$senderpermissions['adminpermissions'] = 2;

						$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
						$pmdm->set_info('is_automated', true);
						$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
						$pmdm->set('fromusername', $vbulletin->userinfo['username']);
						$pmdm->set('title', construct_phrase($vbphrase['challenge_results_t'], $challenge['fromusername'], $challenge['tousername']));
						$pmdm->set('message', construct_phrase($vbphrase['challenge_results_e'], $challenge['fromusername'], $challenge['fromscore'], $challenge['tousername'], $challenge['toscore']));
						$pmdm->set_recipients($otheruser['username'], $senderpermissions);
						$pmdm->set('dateline', TIMENOW);

						$pmdm->save();
					}
				}
			}
			else
			{
				$show['challengepart'] = true;
			}
		}
	}

	// Reverse scoring game
	if ($game['isreverse'])
	{
		$minmaxcount = 'MIN';
		$scoreorder = 'ASC';
		$scoregtlt = '<';
	}
	else
	{
		$minmaxcount = 'MAX';
		$scoreorder = 'DESC';
		$scoregtlt = '>';
	}

	// Time for the scores.
	if ($vbulletin->options['distinctscores'])
	{
		$scorecache = array();
		$scores = $db->query_read("
			SELECT userid, $minmaxcount(score) AS score
			FROM " . TABLE_PREFIX . "v3arcade_sessions
			WHERE gameid = $game[gameid]
				AND valid = 1
			GROUP BY userid
			ORDER BY score $scoreorder, finish DESC
			LIMIT " . $vbulletin->options['scoresperpage']
		);
		while ($score = $db->fetch_array($scores))
		{
			$scorecache[] = "(arcade_sessions.score = $score[score] AND arcade_sessions.userid = $score[userid])";
		}

		$scores = $db->query_read("
			SELECT arcade_sessions.*, user.username, user.arcadeoptions
			FROM " . TABLE_PREFIX . "v3arcade_sessions AS arcade_sessions
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_sessions.userid)
			WHERE arcade_sessions.valid = 1
				AND arcade_sessions.gameid = $game[gameid]
				AND (" . implode(' OR ', $scorecache) . ")
			GROUP BY userid
			ORDER BY score $scoreorder, arcade_sessions.finish DESC
			LIMIT " . $vbulletin->options['scoresperpage']
		);
	}
	else
	{
		$scores = $db->query_read("
			SELECT arcade_sessions.*, user.username, user.arcadeoptions
			FROM " . TABLE_PREFIX . "v3arcade_sessions AS arcade_sessions
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_sessions.userid)
			WHERE arcade_sessions.valid = 1
				AND arcade_sessions.gameid = $game[gameid]
			ORDER BY score $scoreorder, arcade_sessions.finish DESC
			LIMIT " . $vbulletin->options['scoresperpage']
		);
	}

	while ($score = $db->fetch_array($scores))
	{
		if ($vbulletin->options['distinctscores'] AND $score['score'] == $game['score'] AND $score['userid'] == $vbulletin->userinfo['userid'])
		{
			// It's not technically correct, but it saves some messy queries (plus let's a user comment if they tied their previous score).
			$score['sessionid'] = $vbulletin->GPC['id'];
		}

		// It's the score being submitted
		if ($score['sessionid'] == $vbulletin->GPC['id'])
		{
			// $ranking contains the rank of the new session.
			$ranking = $placecounter;

			// Congratulate the user on doing so well.
			$show['highscore'] = true;

			$page = 1;

			if ($permissions['arcadepermissions'] & $vbulletin->bf_ugp['arcadepermissions']['canpostcomments'])
			{
				// It's a new high score - time for the comment form.
				eval('$score[comment] = "' . fetch_template('v3arcade_commentform') . '";');
			}

			// A new champion.
			if ($ranking == 1 AND $vbulletin->userinfo['userid'] != $game['highscorerid'])
			{
				if ($vbulletin->options['neweventonhighscore'])
				{
					// Add a new news item, since there's a new champion for this game.
					insert_arcade_news(construct_phrase(
						$vbphrase['news_x_is_new_champ'],
						$vbulletin->userinfo['username'],
						$game['title'],
						$game['gameid']
					));
				}

				($hook = vBulletinHook::fetch_hook('arcade_new_champion')) ? eval($hook) : false;

				// Break the bad news the next guy/gal.
				$highnotify = true;
			}
		}
		// It's any other score
		else
		{
			$show['highscore'] = false;

			// Send new high score notifications.
			if ($highnotify AND ($score['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['highscorebeaten']))
			{
				if ($score['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['useemail'])
				{
					vbmail($score['email'],
						construct_phrase($vbphrase['notify_highscorebeaten_t'], $game['title'], $vbulletin->userinfo['username']),
						construct_phrase($vbphrase['notify_highscorebeaten_e'], $game['title'], $vbulletin->userinfo['username'], $game['score'], $score['score'], $score['username'], $vbulletin->options['bburl'] . '/arcade.php')
					);
				}

				if ($score['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['usepms'])
				{
					// Override a potentially full inbox.
					$senderpermissions['adminpermissions'] = 2;

					$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
					$pmdm->set_info('is_automated', true);
					$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
					$pmdm->set('fromusername', $vbulletin->userinfo['username']);
					$pmdm->set('title', construct_phrase($vbphrase['notify_highscorebeaten_t'], $game['title'], $vbulletin->userinfo['username']));
					$pmdm->set('message', construct_phrase($vbphrase['notify_highscorebeaten'], $game['title'], $vbulletin->userinfo['username'], $game['score'], $score['score'], $score['username']));
					$pmdm->set_recipients($score['username'], $senderpermissions);
					$pmdm->set('dateline', TIMENOW);

					$pmdm->save();
				}
			}

			$highnotify = false;
		}

		fetch_arcade_score_row($score, true);
	}

	// A final $bgclass switch.
	exec_switch_bg();

	if ($ranking == 1)
	{
		// There's a new high score.
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "v3arcade_games SET
				highscorerid = " . $vbulletin->userinfo['userid'] . ",
				highscore = $game[score],
				highscoredate = " . TIMENOW . "
			WHERE gameid = $game[gameid]
		");

		build_arcade_champ_cache();
		build_arcade_award_cache();
	}
	// If the score didn't make it to page one, find the actual rank.
	else if (!$ranking)
	{
		if ($vbulletin->options['distinctscores'])
		{
			$check = $db->query_first("
				SELECT COUNT(DISTINCT userid) AS rank
				FROM " . TABLE_PREFIX . "v3arcade_sessions
				WHERE gameid = $game[gameid]
					AND valid = 1
					AND score $scoregtlt $game[score]
			");
		}
		else
		{
			$check = $db->query_first("
				SELECT COUNT(*)+1 AS rank
				FROM " . TABLE_PREFIX . "v3arcade_sessions
				WHERE gameid = $game[gameid]
					AND valid = 1
					AND (score $scoregtlt $game[score]
						OR (score = $game[score] AND finish > $game[finish])
					)
			");
		}
		$ranking = $check['rank'];

		$page = ceil($ranking / $vbulletin->options['scoresperpage']);

		if ($permissions['arcadepermissions'] & $vbulletin->bf_ugp['arcadepermissions']['canpostcomments'])
		{
			eval('$game[comment] = "' . fetch_template('v3arcade_commentform') . '";');
		}
	}

	// If a guest just played, adjust the rank (because the session didn't get recorded, and doesn't count)
	if (!$vbulletin->userinfo['userid'])
	{
		$ranking = $ranking - 1;
	}

	$game['ordinal'] = ordinal($ranking);
	$game['rank'] = $ranking;
	$game['sessioncount'] = $game['sessioncount'] + 1;

	// Quick Statistics.
	if ($vbulletin->options['showquickstats'])
	{
		// A manual override for scores of zero, as a more recent loser outranks an older one.
		if (!$game['score'])
		{
			$game['betterthan'] = 0;
			$game['worsethan'] = 100;
		}
		else
		{
			$game['betterthan'] = round(((($game['sessioncount'] - $ranking) + 1) / $game['sessioncount']) * 100);
			$game['worsethan'] = 100 - $game['betterthan'];
		}

		$show['quickstats'] = true;
	}

	$game['score'] = v3_score_format($game['score']);

	// Score Feedback.
	if ($vbulletin->options['showscorefeedback'])
	{
		$show['scorefeedback'] = true;

		// Offer advice based on their score rank.
		$advicep = floor($game['betterthan'] / 20) * 20;
		$vbphrase['arcadeadvise'] = $vbphrase['arcade_' . $advicep];
	}

	// Game Recommendations.
	if ($vbulletin->options['showrecommendations'] AND $newgame = $db->query_first("
			SELECT gameid, miniimage, title
			FROM " . TABLE_PREFIX . "v3arcade_games
			WHERE categoryid = $game[categoryid]
				AND gameid != $game[gameid]
			ORDER BY RAND()
		"))
	{
		$show['recommended'] = true;
		eval('$recommended = "' . fetch_template('v3arcade_recommendation') . '";');
	}

	$scorescolspan = 5;
	if ($vbulletin->options['showlength'] AND !$game['system'])
	{
		$scorescolspan++;
	}

	// Navbar
	$navbits['arcade.php' . $vbulletin->session->vars['sessionurl_q']] = $vbulletin->options['arcadename'];
	$navbits['arcade.php?' . $vbulletin->session->vars['sessionurl'] . 'do=play&amp;gameid=' . $game['gameid']] = $game['title'];
	$navbits[] = $game['title'] . ' ' . $vbphrase['high_scores'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template($navbartemplate) . '";');

	eval('print_output("' . fetch_template('v3ARCADE_SCORES') . '");');
}

// ##### Inline Moderation ####################################################
if ($_POST['do'] == 'inlinemod')
{
	if (!($vbulletin->userinfo['permissions']['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']))
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'action' => TYPE_STR,
		'gameid' => TYPE_UINT,
		'page' => TYPE_UINT,
		'tlist' => TYPE_ARRAY_STR
	));

	// ##### Clear Quick Moderation Cookies
	if ($vbulletin->GPC['action'] == 'clearscores')
	{
		setcookie('vbulletin_inlinethread', '', (TIMENOW - 3600), '/');

		$vbulletin->url = 'arcade.php?' . $vbulletin->session->vars['sessionurl'] . 'do=scores&gameid=' . $vbulletin->GPC['gameid'];
		eval(print_standard_redirect('redirect_inline_threadlist_cleared'));
	}

	$gameid = $vbulletin->GPC['gameid']; 	// set for the inlinemod_confirm template

	$vbulletin->input->clean_gpc('c', 'vbulletin_inlinethread', TYPE_STR);

	// Process sessionids from the cookies
	$cookielist = (trim($vbulletin->GPC['vbulletin_inlinethread'])) ? explode('-', $vbulletin->GPC['vbulletin_inlinethread']) : array();

	if (!empty($vbulletin->GPC['tlist']))
	{
		$cookielist = array_unique(array_merge($cookielist, array_keys($vbulletin->GPC['tlist'])));
	}

	if (empty($cookielist))
	{
		eval(standard_error(fetch_error('v3_no_valid_scores')));
	}

	$sessionids = array();
	foreach ($cookielist AS $listid)
	{
		if (substr($listid, 0, 2) == 's_')
		{
			$sessionids[] = intval(substr($listid, 2));
		}
	}

	if (empty($sessionids))
	{
		eval(standard_error(fetch_error('v3_you_did_not_select_any_valid_scores')));
	}

	$extrahidden = '';

	switch ($vbulletin->GPC['action'])
	{
		// ##### View Selected Scores
		case 'viewscores':
			$frominlinemod = true;
			$_REQUEST['do'] = 'scores';
		break;

		// ##### Delete Scores
		case 'deletescores':

			$formdo = 'inlinemod';
			$formaction = 'dodeletescores';
			$headerphrase = $vbphrase['delete_scores'];
			$confirmphrase = construct_phrase($vbphrase['are_you_sure_delete_x_scores'], sizeof($sessionids));

			$navbits['arcade.php' . $vbulletin->session->vars['sessionurl_q']] = $vbulletin->options['arcadename'];
			$navbits[] = $vbphrase['moderation'];
			$navbits = construct_navbits($navbits);
			eval('$navbar = "' . fetch_template($navbartemplate) . '";');

			eval('print_output("' . fetch_template('v3ARCADE_INLINEMOD_CONFRIM') . '");');

		break;

		// ##### Delete All Scores By Member
		case 'memberdeleteall':

			$membernames = '';
			$comma = '';
			$getmembers = $db->query_read("
				SELECT user.userid, user.username
				FROM " . TABLE_PREFIX . "v3arcade_sessions AS sessions
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON (sessions.userid = user.userid)
				WHERE sessionid IN(" . implode(', ', $sessionids) . ")
				GROUP BY sessions.userid
				ORDER BY user.username
			");
			while ($member = $db->fetch_array($getmembers))
			{
				$membernames .= $comma . '<a href="member.php?u=' . $member['userid'] . '&amp;tab=v3arcade_stats" target="_blank">' . $member['username'] . '</a>';
				$comma = ', ';
			}

			$formdo = 'inlinemod';
			$formaction = 'dodeletemembscores';
			$headerphrase = $vbphrase['delete_scores'];
			$confirmphrase = construct_phrase($vbphrase['are_you_sure_delete_all_scores_x'], $membernames);

			$navbits['arcade.php' . $vbulletin->session->vars['sessionurl_q']] = $vbulletin->options['arcadename'];
			$navbits[] = $vbphrase['moderation'];
			$navbits = construct_navbits($navbits);
			eval('$navbar = "' . fetch_template($navbartemplate) . '";');

			eval('print_output("' . fetch_template('v3ARCADE_INLINEMOD_CONFRIM') . '");');

		break;

		// ##### Do Delete Scores
		case 'dodeletemembscores':

			$memberids = array();
			// Get all sessionids from selected member(s)
			$getmembers = $db->query_read("
				SELECT DISTINCT userid
				FROM " . TABLE_PREFIX . "v3arcade_sessions
				WHERE sessionid IN(" . implode(', ', $sessionids) . ")
			");
			while ($member = $db->fetch_array($getmembers))
			{
				$memberids[] = $member['userid'];
			}

			$othersessions = $db->query_read("
				SELECT sessionid
				FROM " . TABLE_PREFIX . "v3arcade_sessions
				WHERE userid IN(" . implode(', ', $memberids) . ")
			");
			while ($osessions = $db->fetch_array($othersessions))
			{
				$sessionids[] = $osessions['sessionid'];
			}

		case 'dodeletescores':

			$gameinfo = array();
			$getsessions = $db->query_read("
				SELECT sessions.*, games.highscore, games.highscorerid, games.isreverse
				FROM " . TABLE_PREFIX . "v3arcade_sessions AS sessions
				LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS games ON (games.gameid = sessions.gameid)
				WHERE sessionid IN(" . implode(', ', $sessionids) . ")
			");
			while ($gsession = $db->fetch_array($getsessions))
			{
				$gameinfo[$gsession['gameid']]['isreverse'] = $game['isreverse'];
				$gameinfo[$gsession['gameid']]['removecount']++;
				if ($gsession['userid'] == $gsession['highscorerid'] AND $gsession['highscore'] == $gsession['score'])
				{
					$gameinfo[$gsession['gameid']]['newchamp'] = true;
				}
			}

			// Kill the scores
			$db->query_write("
				DELETE FROM " . TABLE_PREFIX . "v3arcade_sessions
				WHERE sessionid IN(" . implode(', ', $sessionids) . ")
			");

			if (!empty($gameinfo))
			{
				$buildchamps = false;
				foreach ($gameinfo AS $gameid => $game)
				{
					$newchampsql = '';
					// Need to find the new champion
					if ($game['newchamp'])
					{
						$buildchamps = true;

						if ($champcheck = $db->query_first("
							SELECT userid, score, finish
							FROM " . TABLE_PREFIX . "v3arcade_sessions
							WHERE valid = 1
								AND gameid = $gameid
							ORDER BY score " . ($isreverse[$gameid] ? 'ASC' : 'DESC') . ", finish
						"))
						{
							$newchampsql = ", highscorerid = $champcheck[userid], highscore = '$champcheck[score]', highscoredate = '$champcheck[finish]'";
						}
						else
						{
							// Just in case you just deleted the last score for this game. You know, it could happen.
							$newchampsql = ', highscorerid = 0, highscore = 0, highscoredate = 0';
						}
					}

					// Reduce the session count for the game.
					$db->query_write("
						UPDATE " . TABLE_PREFIX . "v3arcade_games SET
							sessioncount = sessioncount-$game[removecount]
							$newchampsql
						WHERE gameid = $gameid
					");
				}

				if ($buildchamps)
				{
					build_arcade_champ_cache();
					build_arcade_award_cache();
				}
			}

			$redirectphrase = 'v3_scores_deleted';

		break;

		default:

			($hook = vBulletinHook::fetch_hook('arcade_inlinemod_actions')) ? eval($hook) : false;
	}

	// clear the cookie and redirect if we've made it this far
	setcookie('vbulletin_inlinethread', '', (TIMENOW - 3600), '/');

	$vbulletin->url = 'arcade.php?' . $vbulletin->session->vars['sessionurl'] . 'gameid=' . $vbulletin->GPC['gameid'];
	eval(print_standard_redirect($redirectphrase));
}


// ############################################################################
// SCORES - View scores for a game.
// ############################################################################
if ($_REQUEST['do'] == 'scores')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'gameid' => TYPE_UINT,
		'perpage' => TYPE_UINT,
		'pagenumber' => TYPE_UINT,
		'sessionid' => TYPE_UINT,
		'tid' => TYPE_UINT
	));

	$perpage = $vbulletin->GPC['perpage'];
	$pagenumber = $vbulletin->GPC['pagenumber'];

	$favcache = unserialize($vbulletin->userinfo['favcache']);
	$show['fav'] = ($favcache[$vbulletin->GPC['gameid']]);

	$ratingfields = '';
	$ratingjoin = '';

	if ($vbulletin->userinfo['userid'])
	{
		$ratingfields = ', ratings.rating AS userrating';
		$ratingjoin = 'LEFT JOIN ' . TABLE_PREFIX . 'v3arcade_ratings AS ratings ON (games.gameid = ratings.gameid AND ratings.userid = ' . $vbulletin->userinfo['userid'] . ')';
	}

	$game = $db->query_first("
		SELECT games.* $ratingfields
		FROM " . TABLE_PREFIX . "v3arcade_games AS games
		$ratingjoin
		WHERE games.gameid = " . $vbulletin->GPC['gameid']
	);

	if (!$game['gameid'])
	{
		// Show them the door, since the game doesn't exist.
		eval(standard_error(fetch_error('invalid_x_specified', $vbphrase['game'])));
	}
	
	if ($game['gamepermissions'] & $vbulletin->bf_misc_gamepermissions['disablescoring'])
	{
		eval(standard_error(fetch_error('v3_high_scores_disabled')));
	}

	$scorescolspan = 5;
	if ($vbulletin->options['showlength'] AND !$game['system'])
	{
		$scorescolspan++;
	}

	$show['inlinemod'] = ($vbulletin->userinfo['permissions']['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']);
	if ($show['inlinemod'])
	{
		$scorescolspan++;
	}

	// Get category and page history data.
	$catpagedata = findcatpage();

	if ($game['votecount'])
	{
		$game['rating_acc'] = round(($game['votepoints'] / $game['votecount']), 2);
		$game['rating'] = ceil($game['rating_acc']);
	}

	// Get this user's rating for the current game, if they voted.
	$show['rating'] = true;
	if ($game['userrating'])
	{
		$game['initrating'] = 'starover(' . $game['userrating'] . '); enablerating=0;';
	}

	// We're going to need to parse the comment text.
	require_once(DIR . '/includes/class_bbcode.php');
	$parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());

	if ($frominlinemod AND !empty($sessionids))
	{
		$gamecheck = $db->query_first("
			SELECT COUNT(*) AS sessioncount
			FROM " . TABLE_PREFIX . "v3arcade_sessions
			WHERE gameid = $game[gameid]
				AND sessionid IN(" . implode(', ', $sessionids) . ")
		");
		$game['sessioncount'] = $gamecheck['sessioncount'];
	}
	else if ($vbulletin->options['distinctscores'])
	{
		$gamecheck = $db->query_first("
			SELECT COUNT(*) AS sessioncount
			FROM " . TABLE_PREFIX . "v3arcade_sessions
			WHERE valid = 1
				AND gameid = $game[gameid]
			GROUP BY userid
		");
		$game['sessioncount'] = $gamecheck['sessioncount'];
	}

	// set defaults
	sanitize_pageresults($game['sessioncount'], $pagenumber, $perpage, 100, $vbulletin->options['scoresperpage']);

	$start = intval($perpage * $pagenumber) - $perpage;

	// Defining some miscellaneous variables.
	$placecounter = $start + 1;

	$pagenav = construct_page_nav(
		$pagenumber,
		$perpage,
		$game['sessioncount'],
		'arcade.php?do=scores' . $vbulletin->session->vars['sessionurl'],
		($vbulletin->GPC['gameid'] ? '&amp;gameid=' . $vbulletin->GPC['gameid'] : '')
		. ($vbulletin->GPC['perpage'] ? '&amp;pp=' . $perpage : '')
	);

	// Reverse scoring game
	if ($game['isreverse'])
	{
		$minmaxcount = 'MIN';
		$scoreorder = 'ASC';
		$scoregtlt = '<';
	}
	else
	{
		$minmaxcount = 'MAX';
		$scoreorder = 'DESC';
		$scoregtlt = '>';
	}

	// ##### Time for the scores.
	$scorebits = '';

	if ($game['sessioncount'])
	{
		// Inline Moderation Scores
		if ($frominlinemod AND !empty($sessionids))
		{
			$scores = $db->query_read("
				SELECT arcade_sessions.*, user.username
				FROM " . TABLE_PREFIX . "v3arcade_sessions AS arcade_sessions
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_sessions.userid)
				WHERE arcade_sessions.gameid = $game[gameid]
					AND arcade_sessions.sessionid IN(" . implode(', ', $sessionids) . ")
				ORDER BY score $scoreorder, arcade_sessions.finish DESC
				LIMIT $start, " . $vbulletin->options['scoresperpage']
			);
		}
		// Distinct Scores
		else if ($vbulletin->options['distinctscores'])
		{
			$scorecache = array();
			$scores = $db->query_read("
				SELECT *, $minmaxcount(score) AS score
				FROM " . TABLE_PREFIX . "v3arcade_sessions
				WHERE gameid = $game[gameid]
					AND valid = 1
				GROUP BY userid
				ORDER BY score $scoreorder, finish DESC
				LIMIT $start, " . $vbulletin->options['scoresperpage']
			);
			while ($score = $db->fetch_array($scores))
			{
				$scorecache[] = "(arcade_sessions.score = '$score[score]' AND arcade_sessions.userid = $score[userid])";
			}

			$scores = $db->query_read("
				SELECT arcade_sessions.*, user.username
				FROM " . TABLE_PREFIX . "v3arcade_sessions AS arcade_sessions
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_sessions.userid)
				WHERE arcade_sessions.valid = 1
					AND arcade_sessions.gameid = $game[gameid]
					" . iif(!empty($scorecache), 'AND (' . implode(' OR ', $scorecache) . ')') . "
				GROUP BY userid
				ORDER BY score $scoreorder, arcade_sessions.finish DESC
				LIMIT " . $vbulletin->options['scoresperpage']
			);
		}
		// All Scores
		else
		{
			$scores = $db->query_read("
				SELECT arcade_sessions.*, user.username
				FROM " . TABLE_PREFIX . "v3arcade_sessions AS arcade_sessions
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_sessions.userid)
				WHERE arcade_sessions.gameid = $game[gameid]
					AND arcade_sessions.valid = 1
				ORDER BY score $scoreorder, arcade_sessions.finish DESC
				LIMIT $start, " . $vbulletin->options['scoresperpage']
			);
		}
		while ($score = $db->fetch_array($scores))
		{
			$show['newscore'] = ($score['sessionid'] == $vbulletin->GPC['sessionid']);

			// Permission checking for editing/deletion.
			if ($score['userid'] == $vbulletin->userinfo['userid'])
			{
				$show['editbutton'] = ($permissions['arcadepermissions'] & $vbulletin->bf_ugp['arcadepermissions']['caneditowncomments']);
				$show['deletebutton'] = ($permissions['arcadepermissions'] & $vbulletin->bf_ugp['arcadepermissions']['candeleteownscores']);
			}
			else
			{
				$show['editbutton'] = ($permissions['arcadepermissions'] & $vbulletin->bf_ugp['arcadepermissions']['caneditanycomments']);
				$show['deletebutton'] = ($permissions['arcadepermissions'] & $vbulletin->bf_ugp['arcadepermissions']['candeleteanyscores']);
			}

			fetch_arcade_score_row($score);
		}

		// Get this user's personal best and stats.
		$show['personalbest'] = false;
		$show['tournamentbox'] = false;
		if ($vbulletin->userinfo['userid'])
		{
			// Are we playing a tournament for this game?
			if ($vbulletin->options['tourmnt_enabled'] AND $vbulletin->GPC['tid'])
			{
				// Get tournament info
				$tournament = $db->query_first("
					SELECT arcade_tournaments.*, user.username, arcade_games.title AS a_gametitle, arcade_games.isreverse
					FROM " . TABLE_PREFIX . "v3arcade_tournaments AS arcade_tournaments
					LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_tournaments.creator)
					LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS arcade_games ON (arcade_games.gameid = arcade_tournaments.gameid)
					WHERE tid = " . $vbulletin->GPC['tid']
				);
				if ($tournament['tid'] AND !$tournament['openslots'] AND !$tournament['winner'] AND $tournament['round'])
				{
					// Use the arcade gametitle if there is any.
					if ($tournament['a_gametitle'])
					{
						$tournament['gametitle'] = $tournament['a_gametitle'];
					}

					// Get info about this round
					$playerresult = $db->query_read("
						SELECT arcade_tournamentplayers.*, user.arcadeoptions, user.email, user.username
						FROM " . TABLE_PREFIX . "v3arcade_tournamentplayers AS arcade_tournamentplayers
						LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = arcade_tournamentplayers.userid)
						WHERE round = $tournament[round]
							AND tid = " . $vbulletin->GPC['tid'] . "
						ORDER BY slot ASC
					");
					if ($db->num_rows($playerresult))
					{
						$slots = array();
						while($slot = $db->fetch_array($playerresult))
						{
							$slots[$slot['slot']] = $slot;
							if ($slot['userid'] == $vbulletin->userinfo['userid'])
							{
								$thisplayer = $slot;
							}
						}

						$db->free_result($playerresult);

						if ($thisplayer['tries'] <= $tournament['numtries'])
						{
							$show['tournamentbox'] = true;
						}
					}
				}
			}

			// Personal Best Info
			if ($best = $db->query_read("
				SELECT sessionid, score, finish
				FROM " . TABLE_PREFIX . "v3arcade_sessions
				WHERE valid = 1
					AND gameid = $game[gameid]
					AND userid = " . $vbulletin->userinfo['userid'] . "
				ORDER BY score $scoreorder, finish DESC
			"))
			{
				if ($game['playcount'] = $db->num_rows($best))
				{
					$show['personalbest'] = true;

					$check = $db->fetch_array($best);
					$db->free_result($best);

					$game['pbscore'] = v3_score_format($check['score']);

					if ($vbulletin->options['distinctscores'])
					{
						$check = $db->query_read("
							SELECT sessionid
							FROM " . TABLE_PREFIX . "v3arcade_sessions
							WHERE gameid = $game[gameid]
								AND score $scoregtlt $check[score]
							GROUP BY userid
						");
						$check2 = array('rank' => ($db->num_rows($check) + 1));
					}
					else
					{
						// Unfortunately, we need another query to find out the rank.
						$check2 = $db->query_first("
							SELECT COUNT(*)+1 AS rank
							FROM " . TABLE_PREFIX . "v3arcade_sessions
							WHERE valid = 1
								AND gameid = $game[gameid]
								AND (score $scoregtlt $check[score]
									OR (score = '$check[score]' AND finish > $check[finish])
								)
						");

					}
					$game['pbrank'] = vb_number_format($check2['rank']);
					$game['ordinal'] = ordinal($check2['rank']);
				}
			}
		}
	}

	$show['gameoverview'] = true;

	// Let's get the navbar out of the way.
	$navbits['arcade.php' . $vbulletin->session->vars['sessionurl_q']] = $vbulletin->options['arcadename'];
	$navbits['arcade.php?' . $vbulletin->session->vars['sessionurl'] . 'do=play&amp;gameid=' . $game['gameid']] = $game['title'];
	$navbits[] = "$game[title] $vbphrase[high_scores]";
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template($navbartemplate) . '";');

	eval('print_output("' . fetch_template('v3ARCADE_SCORES') . '");');
}

// ############################################################################
// LEADERBOARDS
// ############################################################################
if ($_REQUEST['do'] == 'leaderboard')
{
	$leadercolspan = 2;
	
	($hook = vBulletinHook::fetch_hook('arcade_leaderboard')) ? eval($hook) : false;

	if (!$vbulletin->options['arcadeleaders'])
	{
		print_no_permission();
	}

	$vbulletin->options['arcadethumbsize'] = $vbulletin->options['arcademinithumbsize'];

	if ($vbulletin->options['leaderboardlastaward'] OR $vbulletin->options['leaderboardlongestaward'])
	{
		// set the colspan
		if ($vbulletin->options['leaderboardlastaward'])
		{
			$leadercolspan++;
		}
	
		if ($vbulletin->options['leaderboardlongestaward'])
		{
			$leadercolspan++;
		}

		$awarddetails = array();

		// Get the latest and longest held awards
		$getdetails = $db->query_read("
			SELECT gameid, title, highscorerid, highscore, highscoredate, miniimage
			FROM " . TABLE_PREFIX . "v3arcade_games
			ORDER BY highscoredate DESC
		");
		while ($adetails = $db->fetch_array($getdetails))
		{
			if (!$adetails['highscorerid'])
			{
				continue;
			}

			if ($awarddetails[$adetails['highscorerid']]['lastaward'] < $adetails['highscoredate'])
			{
				$awarddetails[$adetails['highscorerid']]['lastaward'] = $adetails;
			}

			if (!isset($awarddetails[$adetails['highscorerid']]['longestaward']) OR $awarddetails[$adetails['highscorerid']]['longestaward'] > $adetails['highscoredate'])
			{
				$awarddetails[$adetails['highscorerid']]['longestaward'] = $adetails;
			}
		}
	}

	// Process the leaders
	$leaderboardbits = '';
	foreach (array_slice($vbulletin->v3a_champs, 0, $vbulletin->options['arcadeleaders']) AS $champkey => $champ)
	{
		if ($vbulletin->options['leaderboardawardimg'])
		{
			$champgames_images = fetch_member_award_bits($champ['userid']);
		}

		if ($vbulletin->options['leaderboardlastaward'])
		{
			$lastaward = $awarddetails[$champ['userid']]['lastaward'];
			$lastaward['highscore'] = v3_score_format($lastaward['highscore']);
			$lastaward['date'] = vbdate($vbulletin->options['dateformat'], $lastaward['highscoredate']);
		}
	
		if ($vbulletin->options['leaderboardlongestaward'])
		{
			$longestaward = $awarddetails[$champ['userid']]['longestaward'];
			$longestaward['highscore'] = v3_score_format($longestaward['highscore']);
			$longestaward['date'] = vbdate($vbulletin->options['dateformat'], $longestaward['highscoredate']);
		}
		
		exec_switch_bg();
		eval('$leaderboardbits .= "' . fetch_template('v3arcade_leaderboardbits') . '";');

		$lastrank = $champ['rank'];
	}

	// navbar
	$navbits['arcade.php' . $vbulletin->session->vars['sessionurl_q']] = $vbulletin->options['arcadename'];
	$navbits[] = $vbphrase['arcade_champions'];
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template($navbartemplate) . '";');

	eval('print_output("' . fetch_template('v3ARCADE_LEADERBOARD') . '");');
}

// ############################################################################
// CHALLENGE USER - Challenge a user to a contest.
// ############################################################################
if ($_REQUEST['do'] == 'newchallenge')
{
	$vbulletin->input->clean_gpc('r', 'userid', TYPE_UINT);

	$touser = verify_id('user', $vbulletin->GPC['userid'], true, true, 2);

	if (!$vbulletin->userinfo['userid'] OR !$vbulletin->GPC['userid'] OR !($touser['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['allowchallenges']))
	{
		print_no_permission();
	}

	// Avatar processing.
	$touser['avatar'] = fetch_avatar_url($touser['userid']);
	$touser['useravatar'] = $touser['avatar'][0];
	$touser['avdimensions'] = $touser['avatar'][1];
	if (!$touser['useravatar'])
	{
		$touser['useravatar'] = $vbulletin->options['arcadeimages'] . '/noavatar.gif';
	}

	$vbulletin->userinfo['avatar'] = fetch_avatar_url($vbulletin->userinfo['userid']);
	$vbulletin->userinfo['useravatar'] = $vbulletin->userinfo['avatar'][0];
	$vbulletin->userinfo['avdimensions'] = $vbulletin->userinfo['avatar'][1];
	if (!$vbulletin->userinfo['useravatar'])
	{
		$vbulletin->userinfo['useravatar'] = $vbulletin->options['arcadeimages'] . '/noavatar.gif';
	}

	// Fetch quick statistics.
	$quickstats = array();
	$winners = $db->query_read("
		SELECT COUNT(*) AS count, winnerid
		FROM " . TABLE_PREFIX . "v3arcade_challenges
		WHERE winnerid IN (" . $vbulletin->userinfo['userid'] . ", $touser[userid])
		GROUP BY winnerid
	");
	while (list($count, $userid) = $db->fetch_row($winners))
	{
		$quickstats[$userid]['won'] = $count;
	}

	$losers = $db->query_read("
		SELECT COUNT(*) AS count, loserid
		FROM " . TABLE_PREFIX . "v3arcade_challenges
		WHERE loserid IN (" . $vbulletin->userinfo['userid'] . ", $touser[userid])
		GROUP BY loserid
	");
	while (list($count, $userid) = $db->fetch_row($losers))
	{
		$quickstats[$userid]['lost'] = $count;
	}

	// Adding the stats data into the user arrays. (Used to clear up zero values, too.)
	$vbulletin->userinfo['won'] = intval($quickstats[$vbulletin->userinfo['userid']]['won']);
	$vbulletin->userinfo['lost'] = intval($quickstats[$vbulletin->userinfo['userid']]['lost']);
	$touser['won'] = intval($quickstats[$touser['userid']]['won']);
	$touser['lost'] = intval($quickstats[$touser['userid']]['lost']);

	// Fetch valid games.
	$gameoptions = '';
	$games = $db->query_read("
		SELECT title, gameid
		FROM " . TABLE_PREFIX . "v3arcade_games
		WHERE (gamepermissions & " . $vbulletin->bf_misc_gamepermissions['enablechallenges'] . ")
			AND (gamepermissions & " . $vbulletin->bf_misc_gamepermissions['isactive'] . ")
			AND !(gamepermissions & " . $vbulletin->bf_misc_gamepermissions['disablescoring'] . ")  
		ORDER BY title ASC
	");
	while (list($title, $gameid) = $db->fetch_row($games))
	{
		$gameoptions .= "<option value=\"$gameid\">$title</option>";
	}

	($hook = vBulletinHook::fetch_hook('arcade_newchallenge')) ? eval($hook) : false;

	// Let's get the navbar out of the way.
	$navbits['arcade.php' . $vbulletin->session->vars['sessionurl_q']] = $vbulletin->options['arcadename'];
	$navbits[] = construct_phrase($vbphrase['challenging_x'], $touser['username']);
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template($navbartemplate) . '";');

	eval('print_output("' . fetch_template('v3ARCADE_NEWCHALLENGE') . '");');
}

// ############################################################################
// DO NEW CHALLENGE - Process the new challenge.
// ############################################################################
if ($_REQUEST['do'] == 'donewchallenge')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'userid' => TYPE_UINT,
		'gameid' => TYPE_UINT
	));

	$challenge = $db->query_first("
		SELECT challengeid, title, username
		FROM " . TABLE_PREFIX . "v3arcade_challenges AS arcade_challenges
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_games AS arcade_games ON (arcade_challenges.gameid = arcade_games.gameid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (arcade_challenges.touserid = user.userid)
		WHERE fromuserid = " . $vbulletin->userinfo['userid'] . "
			AND touserid = " . $vbulletin->GPC['userid'] . "
			AND arcade_challenges.gameid = " . $vbulletin->GPC['gameid'] . "
			AND status < 2
	");

	// Make sure there isn't already a challenge like this.
	if ($challenge['challengeid'])
	{
		eval(standard_error(fetch_error(
			'v3_challenge_already_exists',
			$challenge['username'],
			$challenge['title']
		)));
	}

	// Go ahead with the challenge.
	$touser = verify_id('user', $vbulletin->GPC['userid'], true, true, 2);

	if (!($touser['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['allowchallenges']))
	{
		print_no_permission();
	}

	// Check that the game exists.
	if (!$game = $db->query_first("SELECT gameid, title FROM " . TABLE_PREFIX . "v3arcade_games WHERE gameid = " . $vbulletin->GPC['gameid']))
	{
		print_no_permission();
	}

	// The challenged user wants to automatically accept all challenges.
	$status = ($touser['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['autoaccept']) ? 1 : 0;

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "v3arcade_challenges
			(fromuserid, touserid, gameid, datestamp, status)
		VALUES (
			" . $vbulletin->userinfo['userid'] . ",
			$touser[userid],
			" . $vbulletin->GPC['gameid'] . ",
			" . TIMENOW . ",
			$status
	)");
	$challengeid = $db->insert_id();

	if ($touser['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['newchallenge'])
	{
		if ($touser['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['useemail'])
		{
			vbmail($touser['email'],
			construct_phrase($vbphrase['new_challenge_t'], $vbulletin->userinfo['username']),
			construct_phrase($vbphrase['new_challenge_e'], $vbulletin->userinfo['username'], $vbulletin->options['bburl'] . '/arcade.php?do=play&challengeid=' . $challengeid, $game['title'], $vbulletin->options['bburl'] . '/arcade.php?do=declinechallenge&challengeid=' . $challengeid)
			);
		}

		if ($touser['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['usepms'])
		{
			// Override a potentially full inbox.
			$senderpermissions['adminpermissions'] = 2;

			$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
			$pmdm->set_info('is_automated', true);
			$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
			$pmdm->set('fromusername', $vbulletin->userinfo['username']);
			$pmdm->set('title', construct_phrase($vbphrase['new_challenge_t'], $vbulletin->userinfo['username']));
			$pmdm->set('message', construct_phrase($vbphrase['new_challenge_p'], $vbulletin->userinfo['username'], $vbulletin->options['bburl'] . '/arcade.php?do=play&challengeid=' . $challengeid, $game['title'], $vbulletin->options['bburl'] . '/arcade.php?do=declinechallenge&challengeid=' . $challengeid));
			$pmdm->set_recipients($touser['username'], $senderpermissions);
			$pmdm->set('dateline', TIMENOW);

			$pmdm->save();
		}
	}

	($hook = vBulletinHook::fetch_hook('arcade_donewchallenge')) ? eval($hook) : false;

	$vbulletin->url = 'arcade.php?' . $vbulletin->session->vars['sessionurl'] . 'do=play&gameid=' . $game['gameid'] . '&challengeid=' . $challengeid;
	eval(print_standard_redirect('v3_your_challenge_has_been_submitted'));
}

// ############################################################################
// DECLINE CHALLENGE - Decline someone's challenge.
// ############################################################################
if ($_REQUEST['do'] == 'declinechallenge')
{
	$vbulletin->input->clean_gpc('r', 'challengeid', TYPE_UINT);

	$challenge = $db->query_first("
		SELECT challengeid, fromuserid, touserid
		FROM " . TABLE_PREFIX . "v3arcade_challenges
		WHERE challengeid = " . $vbulletin->GPC['challengeid']
	);

	if (!$challenge['challengeid'])
	{
		print_no_permission();
	}

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "v3arcade_challenges SET
			status = 2
		WHERE challengeid = " . $vbulletin->GPC['challengeid']
	);

	$otheruser = fetch_userinfo($challenge['fromuserid']);

	if ($otheruser['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['challengedeclined'])
	{
		if ($otheruser['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['useemail'])
		{
			vbmail($otheruser['email'],
			construct_phrase($vbphrase['challenge_declined_t'], $otheruser['username'], $vbulletin->userinfo['username']),
			construct_phrase($vbphrase['challenge_declined_e'], $otheruser['username'], $vbulletin->userinfo['username'])
			);
		}

		if ($otheruser['arcadeoptions'] & $vbulletin->bf_misc_arcadeoptions['usepms'])
		{
			// Override a potentially full inbox.
			$senderpermissions['adminpermissions'] = 2;

			$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
			$pmdm->set_info('is_automated', true);
			$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
			$pmdm->set('fromusername', $vbulletin->userinfo['username']);
			$pmdm->set('title', construct_phrase($vbphrase['challenge_declined_t'], $otheruser['username'], $vbulletin->userinfo['username']));
			$pmdm->set('message', construct_phrase($vbphrase['challenge_declined_e'], $otheruser['username'], $vbulletin->userinfo['username']));
			$pmdm->set_recipients($otheruser['username'], $senderpermissions);
			$pmdm->set('dateline', TIMENOW);

			$pmdm->save();
		}
	}

	($hook = vBulletinHook::fetch_hook('arcade_declinechallenge')) ? eval($hook) : false;

	$vbulletin->url = 'arcade.php' . $vbulletin->session->vars['sessionurl_q'];
	eval(print_standard_redirect('v3_challenge_declined'));
}

($hook = vBulletinHook::fetch_hook('arcade_global_complete')) ? eval($hook) : false;

?>